/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.ViewImplementation;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public class NonEditableEntryView
implements ViewImplementation {
    private EclDataEntryView myDelegator;
    private Point textOrigin = new Point(0, 0);
    private int textHeight = 0;
    private boolean inError = false;
    private static final int bodge = EclipseSystem.instance().isOnInstrument() ? 1 : 0;

    public NonEditableEntryView(EclDataEntryView eclDataEntryView) {
        this.myDelegator = eclDataEntryView;
    }

    private void calculateTextXLocation(Rectangle rectangle, FontMetrics fontMetrics) {
        String string = Beans.isDesignTime() ? this.fillWithHashes() : this.myDelegator.getTextProperty();
        this.textOrigin.x = string == null ? rectangle.width - 3 : rectangle.width - 3 - fontMetrics.stringWidth(string);
    }

    private String fillWithHashes() {
        StringBuffer stringBuffer = new StringBuffer(this.myDelegator.getMaxLength());
        int n = 0;
        while (n < this.myDelegator.getMaxLength()) {
            stringBuffer.append("#");
            ++n;
        }
        return stringBuffer.toString();
    }

    private EclDataEntry getController() {
        return this.myDelegator.getController();
    }

    public MouseActionnedComponent getMouseActionnedComponent() {
        return null;
    }

    public void notifyEclipseComponentChanged() {
        FontMetrics fontMetrics = null;
        if (this.getController().getFont() != null) {
            fontMetrics = this.getController().getFontMetrics(this.getController().getFont());
        }
        if (fontMetrics != null) {
            Rectangle rectangle = this.getController().getBounds();
            this.textHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            if (this.myDelegator.isRightJustified()) {
                this.calculateTextXLocation(rectangle, fontMetrics);
            } else {
                this.textOrigin.x = 3;
            }
            this.textOrigin.y = (rectangle.height - this.textHeight) / 2 + fontMetrics.getMaxAscent() + bodge;
        }
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        if (!this.inError) {
            this.paintText(graphics);
        }
        this.paintBorders(graphics);
    }

    private void paintBackground(Graphics graphics) {
        if (this.inError) {
            graphics.setColor(EclDataEntryDefaults.transientErrorColour);
            graphics.fillRect(0, 0, this.getController().getBounds().width, this.getController().getBounds().height);
        } else if (this.myDelegator.getBackground() != null) {
            graphics.setColor(this.myDelegator.getBackground());
            graphics.fillRect(0, 0, this.getController().getBounds().width, this.getController().getBounds().height);
        }
    }

    private void paintBorders(Graphics graphics) {
        if (this.getController().isEnabled()) {
            graphics.setColor(EclDataEntryDefaults.borderOutsideRectangleColor);
            graphics.drawRect(0, 0, this.getController().getBounds().width - 2, this.getController().getBounds().height - 2);
            graphics.setColor(EclDataEntryDefaults.borderInsideRectangleColor);
            graphics.drawRect(1, 1, this.getController().getBounds().width - 2, this.getController().getBounds().height - 2);
        } else {
            graphics.setColor(EclDataEntryDefaults.borderDisableRectangleColor);
            graphics.drawRect(0, 0, this.getController().getBounds().width - 1, this.getController().getBounds().height - 1);
        }
        if (this.getController().hasFocus()) {
            graphics.setColor(EclDataEntryDefaults.focusColour);
            graphics.drawRect(0, 0, this.getController().getBounds().width - 2, this.getController().getBounds().height - 2);
        }
    }

    private void paintText(Graphics graphics) {
        if (this.myDelegator.getTextProperty() != null && this.myDelegator.isValid()) {
            if (this.getController().isEnabled()) {
                graphics.setColor(this.getController().getForeground());
            } else {
                graphics.setColor(this.getController().getForeground().brighter());
            }
            graphics.setFont(this.getController().getFont() == null ? EclDataEntryDefaults.font : this.getController().getFont());
            graphics.drawString(this.myDelegator.getTextProperty(), this.textOrigin.x, this.textOrigin.y);
        } else if (!this.myDelegator.isValid() || Beans.isDesignTime()) {
            graphics.setColor(Color.black);
            graphics.setFont(this.getController().getFont() == null ? EclDataEntryDefaults.font : this.getController().getFont());
            graphics.drawString(this.fillWithHashes(), this.textOrigin.x, this.textOrigin.y);
        }
    }

    public void sendFocusEvent(FocusEvent focusEvent) {
    }

    public void sendKeyEvent(KeyEvent keyEvent) {
    }

    public boolean setTextProperty(String string) {
        this.inError = true;
        if (string != null) {
            if (this.myDelegator.isRightJustified()) {
                this.calculateTextXLocation(this.getController().getBounds(), this.getController().getFontMetrics(this.getController().getFont()));
            }
            if (string.length() <= this.myDelegator.getMaxLength()) {
                this.inError = false;
            }
        }
        return true;
    }

    public void unregister() {
    }
}

