/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.statusline.StatusLineApplication;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EditableEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EntryTypeState;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

class TextState
extends EntryTypeState {
    private KeyEvent previousKeyEvent = null;
    private static final int KEYMODE_OFF = 0;
    private static final String KEYMODE_OFF_TEXT = "";
    private static final int KEYMODE_CAPS = 1;
    private static final String KEYMODE_CAPS_TEXT = "Caps";
    private static final int KEYMODE_NUM = 2;
    private static final String KEYMODE_NUM_TEXT = "Num";
    private static int keyMode;

    public String getTypeString() {
        return "Txt";
    }

    public boolean isInsertModeSupported() {
        return true;
    }

    public boolean isSeparatorChar(char c) {
        return false;
    }

    public boolean isValid(String string) {
        return true;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                this.setStatusLine();
                break;
            }
            case 1005: {
                StatusLineApplication.getInstance().setDataEntryMode(KEYMODE_OFF_TEXT);
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent, EditableEntryView editableEntryView) {
        switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
            case 2000: {
                this.selectCharacter(EclDataEntryDefaults.smallONE, EclDataEntryDefaults.bigONE, EclDataEntryDefaults.intONE, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2001: {
                this.selectCharacter(EclDataEntryDefaults.smallTWO, EclDataEntryDefaults.bigTWO, EclDataEntryDefaults.intTWO, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2002: {
                this.selectCharacter(EclDataEntryDefaults.smallTHREE, EclDataEntryDefaults.bigTHREE, EclDataEntryDefaults.intTHREE, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2003: {
                this.selectCharacter(EclDataEntryDefaults.smallFOUR, EclDataEntryDefaults.bigFOUR, EclDataEntryDefaults.intFOUR, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2004: {
                this.selectCharacter(EclDataEntryDefaults.smallFIVE, EclDataEntryDefaults.bigFIVE, EclDataEntryDefaults.intFIVE, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2005: {
                this.selectCharacter(EclDataEntryDefaults.smallSIX, EclDataEntryDefaults.bigSIX, EclDataEntryDefaults.intSIX, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2006: {
                this.selectCharacter(EclDataEntryDefaults.smallSEVEN, EclDataEntryDefaults.bigSEVEN, EclDataEntryDefaults.intSEVEN, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2007: {
                this.selectCharacter(EclDataEntryDefaults.smallEIGHT, EclDataEntryDefaults.bigEIGHT, EclDataEntryDefaults.intEIGHT, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2008: {
                this.selectCharacter(EclDataEntryDefaults.smallNINE, EclDataEntryDefaults.bigNINE, EclDataEntryDefaults.intNINE, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2009: {
                this.selectCharacter(EclDataEntryDefaults.smallZERO, EclDataEntryDefaults.bigZERO, EclDataEntryDefaults.intZERO, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2015: {
                keyMode = (keyMode + 1) % 3;
                this.setStatusLine();
                break;
            }
            case 2018: {
                this.selectCharacter(EclDataEntryDefaults.smallSUBTRACT, EclDataEntryDefaults.bigSUBTRACT, EclDataEntryDefaults.intSUBTRACT, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            case 2017: {
                this.selectCharacter(EclDataEntryDefaults.smallPERIOD, EclDataEntryDefaults.bigPERIOD, EclDataEntryDefaults.intPERIOD, keyEvent, editableEntryView);
                keyEvent.consume();
                break;
            }
            default: {
                if (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 157 || keyEvent.getKeyCode() == 9) break;
                if (keyEvent.isActionKey()) {
                    if (keyEvent.getKeyChar() != 'p' && keyEvent.getKeyChar() != 'q' && keyEvent.getKeyChar() != 'r' && keyEvent.getKeyChar() != 's' && keyEvent.getKeyChar() != 't' && keyEvent.getKeyChar() != 'u' && keyEvent.getKeyChar() != 'v' && keyEvent.getKeyChar() != 'w' && keyEvent.getKeyChar() != 'x' && keyEvent.getKeyChar() != 'y' && keyEvent.getKeyChar() != 'z' && keyEvent.getKeyChar() != '{') break;
                    editableEntryView.processChar(keyEvent.getKeyChar());
                    keyEvent.consume();
                    break;
                }
                editableEntryView.processChar(keyEvent.getKeyChar());
                keyEvent.consume();
            }
        }
    }

    protected void selectCharacter(char[] cArray, char[] cArray2, char[] cArray3, KeyEvent keyEvent, EditableEntryView editableEntryView) {
        if (this.shouldReplaceCharacter(keyEvent)) {
            if (keyMode == 0) {
                this.toggleChar(cArray, editableEntryView);
            } else if (keyMode == 1) {
                this.toggleChar(cArray2, editableEntryView);
            } else {
                this.toggleChar(cArray3, editableEntryView);
            }
        } else if (keyMode == 0) {
            editableEntryView.processChar(cArray[0]);
        } else if (keyMode == 1) {
            editableEntryView.processChar(cArray2[0]);
        } else {
            editableEntryView.processChar(cArray3[0]);
        }
    }

    private void setStatusLine() {
        switch (keyMode) {
            case 0: {
                StatusLineApplication.getInstance().setDataEntryMode(KEYMODE_OFF_TEXT);
                break;
            }
            case 1: {
                StatusLineApplication.getInstance().setDataEntryMode(KEYMODE_CAPS_TEXT);
                break;
            }
            case 2: {
                StatusLineApplication.getInstance().setDataEntryMode(KEYMODE_NUM_TEXT);
            }
        }
    }

    private boolean shouldReplaceCharacter(KeyEvent keyEvent) {
        boolean bl = false;
        if (this.previousKeyEvent != null && this.previousKeyEvent.getKeyCode() == keyEvent.getKeyCode() && keyEvent.getWhen() - this.previousKeyEvent.getWhen() < 600L) {
            bl = true;
        }
        this.previousKeyEvent = keyEvent;
        return bl;
    }

    public boolean supportPaddedText() {
        return false;
    }

    private void toggleChar(char[] cArray, EditableEntryView editableEntryView) {
        char c = editableEntryView.removePreviousCharacter();
        int n = 0;
        boolean bl = c == '\u0000';
        while (!bl) {
            if (cArray[n] == c) {
                bl = true;
                if (n != cArray.length - 1) {
                    editableEntryView.processChar(cArray[n + 1]);
                } else {
                    editableEntryView.processChar(cArray[0]);
                }
            }
            if (++n != cArray.length - 1 || bl) continue;
            bl = true;
            editableEntryView.processChar(cArray[0]);
        }
    }

    TextState() {
    }
}

