/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.formattedresult;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFormattedResultDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.EclFormattedResultModel;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.EclFormattedResultView;
import java.awt.Color;
import java.beans.Beans;

public class EclFormattedResult
extends EclipseComponent
implements CcGreyableComponent,
KnownLengthStringDataReceiver {
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient boolean hasTrappedTransientError = false;
    private transient KnownLengthStringValue thePreviousStringValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient EclFormattedResultView eclView = null;
    private EclFormattedResultModel eclModel = null;

    public EclFormattedResult() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            if (this.eclModel.getPropertyIDForName(string) == 10) {
                this.theApplicationObject = applicationObject;
            } else {
                this.theGreyApplicationObject = applicationObject;
            }
        }
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclFormattedResultDefaults.transientErrorColour : super.getBackground();
    }

    EclFormattedResultView getEclFormattedResultView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclFormattedResultView();
    }

    public EclFormattedResultModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclFormattedResultModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    protected void initialiseModel() {
        EclFormattedResultModel eclFormattedResultModel = this.getEclModel();
        if (this.eclView == null) {
            eclFormattedResultModel.createView();
        }
    }

    void permanentError() {
        this.setBackground(EclFormattedResultDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue knownLengthStringValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender.equals(this.theApplicationObject)) {
            if (!knownLengthStringValue.equals(this.thePreviousStringValue)) {
                this.thePreviousStringValue = knownLengthStringValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.eclView.setText(knownLengthStringValue.getValue()));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclFormattedResultView(EclFormattedResultView eclFormattedResultView) {
        this.eclView = eclFormattedResultView;
    }

    public void setEclModel(EclFormattedResultModel eclFormattedResultModel) {
        this.eclModel = eclFormattedResultModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
    }

    private void testForValidity() {
        if (this.thePreviousStringValue != null && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.trapTransientError(!this.getEclFormattedResultView().setText(this.thePreviousStringValue.getValue()));
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclFormattedResult" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this, this.getEclModel().getMetaData());
            this.theApplicationObject = null;
            this.thePreviousStringValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

