/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.formattedresult;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.IssResultMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFormattedResultDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.AccessibleEclFormattedResultModel;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.EclFormattedResult;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.EclFormattedResultView;
import java.awt.Color;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclFormattedResultModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 2536069975286988011L;
    private String databaseVariable;
    private int databaseVariableDomain;
    private String databaseGreyVariable;
    private int databaseGreyDomain;
    private int resultType;
    private String formatFlags;
    private int maxLength;
    private Color errorColour;
    private transient EclFormattedResult controller;
    private transient IssResultMetaData metaData = null;

    public EclFormattedResultModel() {
        this(null, null, 0, "", 0, "", Color.red);
    }

    public EclFormattedResultModel(String string, int n, String string2, int n2, int n3, String string3, int n4, Color color) {
        this.databaseVariable = string;
        this.databaseVariableDomain = n;
        this.databaseGreyVariable = string2;
        this.databaseVariableDomain = n2;
        this.resultType = n3;
        this.formatFlags = string3;
        this.maxLength = n4;
        this.errorColour = color;
    }

    public EclFormattedResultModel(String string, String string2, int n, String string3, int n2, String string4, Color color) {
        this(string, 0, string2, 0, n, string3, n2, color);
    }

    AccessibleEclFormattedResultModel createAccessibleModel() {
        return new AccessibleEclFormattedResultModel(this.databaseVariable, this.databaseVariableDomain, this.databaseGreyVariable, this.databaseGreyDomain, this.resultType, this.formatFlags, this.maxLength, this.errorColour, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclFormattedResultDefaults.background);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclFormattedResultDefaults.font);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclFormattedResultDefaults.foreground);
        }
        if (this.controller.getEclFormattedResultView() == null) {
            this.controller.setEclFormattedResultView(new EclFormattedResultView(this.controller, Beans.isDesignTime()));
        }
        this.controller.getEclFormattedResultView().setMaxLength(this.maxLength);
    }

    public void finishInitialise() {
        if (this.databaseVariable == null) {
            EventLog.instance().log(String.valueOf(this.controller.toString()) + " requires a variable name.");
            this.controller.permanentError();
        } else {
            ApplicationManager.instance().request(this.databaseVariableDomain, 0, this.databaseVariable, (ApplicationObjectObserver)this.controller, (ApplicationMetaData)this.getMetaData());
            if (this.databaseGreyVariable != null) {
                ApplicationManager.instance().request(this.databaseGreyDomain, 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.controller);
            }
        }
    }

    IssResultMetaData getMetaData() {
        if (this.metaData == null && this.resultType != -1) {
            this.metaData = new IssResultMetaData(this.formatFlags, this.resultType);
        }
        return this.metaData;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclFormattedResultDefaults.font);
        this.controller.setForeground(EclFormattedResultDefaults.foreground);
        this.controller.setBackground(EclFormattedResultDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.resultType = objectInputStream.readInt();
                this.formatFlags = (String)objectInputStream.readObject();
                this.maxLength = objectInputStream.readInt();
                objectInputStream.readObject();
                this.errorColour = (Color)objectInputStream.readObject();
                break;
            }
            case 1: {
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseVariableDomain = objectInputStream.readInt();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.databaseGreyDomain = objectInputStream.readInt();
                this.resultType = objectInputStream.readInt();
                this.formatFlags = (String)objectInputStream.readObject();
                this.maxLength = objectInputStream.readInt();
                this.errorColour = (Color)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclFormattedResultModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclFormattedResult eclFormattedResult) {
        this.controller = eclFormattedResult;
    }

    public String toString() {
        return "[" + (this.databaseVariable == null ? "null" : this.databaseVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + ", " + (this.getMetaData() == null ? "default format" : "redefined format") + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.controller.setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.controller.setGreying(false, false);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.databaseVariable);
        objectOutputStream.writeInt(this.databaseVariableDomain);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeInt(this.databaseGreyDomain);
        objectOutputStream.writeInt(this.resultType);
        objectOutputStream.writeObject(this.formatFlags);
        objectOutputStream.writeInt(this.maxLength);
        objectOutputStream.writeObject(this.errorColour);
    }
}

