/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.formattedresult;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFormattedResultDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.formattedresult.EclFormattedResult;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class EclFormattedResultView
implements EclipseView {
    private EclFormattedResult controller = null;
    private String theText = "";
    private boolean valid = true;
    private final boolean isDesignTime;
    private Point textOrigin = new Point(0, 0);
    private int textHeight = 0;
    private int maxLength = 0;
    private int maxVisible = 0;

    public EclFormattedResultView(EclFormattedResult eclFormattedResult, boolean bl) {
        this.controller = eclFormattedResult;
        this.isDesignTime = bl;
        if (eclFormattedResult != null) {
            this.calculateGeometry();
        } else {
            System.out.println("null controller in constructor!");
        }
    }

    protected void calculateGeometry() {
        Rectangle rectangle = this.controller.getBounds();
        FontMetrics fontMetrics = null;
        if (this.controller.getFont() != null) {
            fontMetrics = this.controller.getFontMetrics(this.controller.getFont());
        }
        if (fontMetrics != null) {
            this.textHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.textOrigin.x = 3;
            this.textOrigin.y = (rectangle.height - this.textHeight) / 2 + fontMetrics.getMaxAscent();
            this.maxVisible = (rectangle.width - 6) / fontMetrics.charWidth('0');
            if (this.maxVisible < this.maxLength) {
                this.makeInvalid();
            } else {
                this.valid = true;
            }
        }
    }

    private void fillWithHashes() {
        this.theText = "";
        int n = 0;
        while (n < this.maxLength) {
            this.theText = String.valueOf(this.theText) + "#";
            ++n;
        }
    }

    private Color getBackground() {
        if (!this.valid) {
            return EclFormattedResultDefaults.permanentErrorColour;
        }
        return this.controller.getBackground();
    }

    private String getText() {
        return this.theText;
    }

    private void makeInvalid() {
        if (this.valid) {
            this.valid = false;
            this.fillWithHashes();
            this.controller.repaint();
        }
    }

    public void notifyEclipseComponentChanged() {
        this.calculateGeometry();
        this.controller.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.controller.getBounds().width, this.controller.getBounds().height);
        }
        graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.controller.getVisibleBackground().darker());
        graphics.setFont(this.controller.getFont());
        if (this.isDesignTime) {
            String string = this.getText().length() == 0 ? this.controller.getName() : this.getText();
            graphics.drawString(string, this.textOrigin.x, this.textOrigin.y);
        } else {
            graphics.drawString(this.getText(), this.textOrigin.x, this.textOrigin.y);
        }
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
        this.calculateGeometry();
        this.controller.repaint();
    }

    public boolean setText(String string) {
        boolean bl = true;
        if (string == null) {
            string = "";
        }
        if (string.length() <= this.maxLength) {
            this.theText = string;
        } else {
            this.fillWithHashes();
            bl = false;
        }
        return bl;
    }
}

