/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFuelGaugeDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeAxis;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeModel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeView;
import java.awt.Color;
import java.awt.Container;
import java.beans.Beans;

public class EclFuelGauge
extends EclipseComponent
implements CcConnectedComponent,
MaskedIntegerDataReceiver,
KnownLengthStringDataReceiver {
    private EclFuelGaugeModel eclModel = null;
    private transient EclFuelGaugeView eclView = null;
    private transient ApplicationObject theApplicationObject = null;
    private transient boolean hasTrappedTransientError = false;
    private EclFuelGaugeAxis fieldAxis = new EclFuelGaugeAxis();

    public EclFuelGauge() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(100, 20);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    public void finishInitialise() {
        this.getEclModel().finishInitialise();
    }

    EclFuelGaugeAxis getAxis() {
        return this.fieldAxis;
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclFuelGaugeDefaults.transientErrorColour : super.getBackground();
    }

    public EclFuelGaugeView getEclFuelGaugeView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.eclView;
    }

    public EclFuelGaugeModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclFuelGaugeModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public double getValue() {
        return this.getEclFuelGaugeView().getValue();
    }

    public Color getVisibleBackground() {
        Container container = this.getParent();
        while (container != null) {
            if (container.getBackground() != null) {
                return container.getBackground();
            }
            container = container.getParent();
        }
        return Color.lightGray;
    }

    protected void initialiseModel() {
        EclFuelGaugeModel eclFuelGaugeModel = this.getEclModel();
        if (this.eclView == null) {
            eclFuelGaugeModel.createView();
        }
    }

    void permanentError() {
        this.setBackground(EclFuelGaugeDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue knownLengthStringValue, ApplicationDataSender applicationDataSender) {
        this.trapTransientError(false);
        try {
            Float f = Float.valueOf(knownLengthStringValue.getValue());
            this.eclView.setValue(f.floatValue());
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        this.getEclFuelGaugeView().setValue(maskedIntegerValue.getValue());
        this.repaint();
    }

    public void setAxis(EclFuelGaugeAxis eclFuelGaugeAxis) {
        this.fieldAxis = eclFuelGaugeAxis;
    }

    public void setEclFuelGaugeView(EclFuelGaugeView eclFuelGaugeView) {
        this.eclView = eclFuelGaugeView;
    }

    public void setEclModel(EclFuelGaugeModel eclFuelGaugeModel) {
        this.eclModel = eclFuelGaugeModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setValue(double d) {
        this.getEclFuelGaugeView().setValue(d);
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclFuelGauge" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (bl) {
            this.getEclFuelGaugeView().setValue(0);
        }
        this.hasTrappedTransientError = bl;
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

