/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFuelGaugeAxisDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.AccessibleEclFuelGaugeAxisModel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeAxis;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeAxisView;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.FloatThresholdInfo;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.ThresholdInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclFuelGaugeAxisModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 3748529493624123133L;
    private transient EclFuelGaugeAxis controller;
    private int orientation;
    private int min;
    private int max;
    private int numTicks;
    private ThresholdInfo[] thresholds;
    private double minD;
    private double maxD;
    private FloatThresholdInfo[] floatThresholds;

    public EclFuelGaugeAxisModel() {
        this(0, 0.0, 100.0, 2, new FloatThresholdInfo[0], 0);
    }

    public EclFuelGaugeAxisModel(int n, double d, double d2, int n2, FloatThresholdInfo[] floatThresholdInfoArray, int n3) {
        this.orientation = n;
        this.min = (int)d;
        this.max = (int)d2;
        this.numTicks = n2;
        this.minD = d;
        this.maxD = d2;
        this.floatThresholds = floatThresholdInfoArray != null ? floatThresholdInfoArray : new FloatThresholdInfo[0];
    }

    public EclFuelGaugeAxisModel(int n, int n2, int n3, int n4, ThresholdInfo[] thresholdInfoArray) {
        this.orientation = n;
        this.min = n2;
        this.max = n3;
        this.numTicks = n4;
        this.minD = this.min;
        this.maxD = this.max;
        this.thresholds = thresholdInfoArray != null ? thresholdInfoArray : new ThresholdInfo[0];
        this.floatThresholds = this.generateThresholds(this.thresholds);
    }

    protected AccessibleEclFuelGaugeAxisModel createAccessibleModel() {
        return new AccessibleEclFuelGaugeAxisModel(this.orientation, this.minD, this.maxD, this.numTicks, this.floatThresholds, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclFuelGaugeAxisDefaults.background);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclFuelGaugeAxisDefaults.foreground);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclFuelGaugeAxisDefaults.font);
        }
        if (this.controller.getEclFuelGaugeAxisView() == null) {
            this.controller.setEclFuelGaugeAxisView(new EclFuelGaugeAxisView(this.controller));
        }
        this.controller.getEclFuelGaugeAxisView().initialise(this.orientation, this.minD, this.maxD, this.numTicks, this.floatThresholds);
    }

    private FloatThresholdInfo[] generateThresholds(ThresholdInfo[] thresholdInfoArray) {
        FloatThresholdInfo[] floatThresholdInfoArray = new FloatThresholdInfo[thresholdInfoArray.length];
        int n = 0;
        while (n < thresholdInfoArray.length) {
            floatThresholdInfoArray[n] = new FloatThresholdInfo(thresholdInfoArray[n].upTo, thresholdInfoArray[n].colour);
            ++n;
        }
        return floatThresholdInfoArray;
    }

    private EclFuelGaugeAxis getController() {
        return this.controller;
    }

    public void initialiseDefaults() {
        this.controller.setBackground(EclFuelGaugeAxisDefaults.background);
        this.controller.setForeground(EclFuelGaugeAxisDefaults.foreground);
        this.controller.setFont(EclFuelGaugeAxisDefaults.font);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.orientation = objectInputStream.readInt();
                this.min = objectInputStream.readInt();
                this.max = objectInputStream.readInt();
                this.numTicks = objectInputStream.readInt();
                this.thresholds = (ThresholdInfo[])objectInputStream.readObject();
                this.floatThresholds = this.generateThresholds(this.thresholds);
                this.minD = this.min;
                this.maxD = this.max;
                break;
            }
            case 1: {
                this.orientation = objectInputStream.readInt();
                this.minD = objectInputStream.readDouble();
                this.maxD = objectInputStream.readDouble();
                this.numTicks = objectInputStream.readInt();
                this.floatThresholds = (FloatThresholdInfo[])objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclFuelGaugeAxisModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclFuelGaugeAxis eclFuelGaugeAxis) {
        this.controller = eclFuelGaugeAxis;
    }

    public String toString() {
        return "[" + this.controller.getName() + ", " + this.thresholds + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(this.orientation);
        objectOutputStream.writeDouble(this.minD);
        objectOutputStream.writeDouble(this.maxD);
        objectOutputStream.writeInt(this.numTicks);
        objectOutputStream.writeObject(this.floatThresholds);
    }
}

