/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeAxis;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.FloatThresholdInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class EclFuelGaugeAxisView
implements EclipseView {
    private EclFuelGaugeAxis controller;
    private int orientation = 0;
    private double min = 0.0;
    private double max = 100.0;
    private int numTicks = 2;
    private FloatThresholdInfo[] floatThresholds = new FloatThresholdInfo[0];

    public EclFuelGaugeAxisView(EclFuelGaugeAxis eclFuelGaugeAxis) {
        this.controller = eclFuelGaugeAxis;
        if (this.controller != null) {
            this.notifyEclipseComponentChanged();
        } else {
            System.out.println("Null controller in EclFuelGaugeAxisView constructor!");
        }
    }

    protected Color getColorForValue(double d) {
        double d2 = this.min;
        int n = 0;
        while (n < this.floatThresholds.length) {
            FloatThresholdInfo floatThresholdInfo = this.floatThresholds[n];
            if (d >= d2 && d <= floatThresholdInfo.upTo) {
                return floatThresholdInfo.colour;
            }
            d2 = floatThresholdInfo.upTo;
            ++n;
        }
        return null;
    }

    protected double getMax() {
        return this.max;
    }

    protected double getMin() {
        return this.min;
    }

    protected int getNumTicks() {
        return this.numTicks;
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void initialise(int n, double d, double d2, int n2, FloatThresholdInfo[] floatThresholdInfoArray) {
        this.orientation = n;
        this.min = d;
        this.max = d2;
        this.numTicks = n2;
        this.floatThresholds = floatThresholdInfoArray != null ? floatThresholdInfoArray : new FloatThresholdInfo[0];
        this.controller.repaint();
    }

    private int mapValuetoCoord(double d) {
        return (int)((d - this.min) * (double)this.controller.getSize().width / (this.max - this.min));
    }

    public void notifyEclipseComponentChanged() {
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.controller.getForeground());
        graphics.drawLine(0, 2, this.controller.getSize().width, 2);
        int n = 0;
        while (n <= this.numTicks) {
            graphics.drawLine(n * (this.controller.getSize().width - 1) / this.numTicks, 2, n * (this.controller.getSize().width - 1) / this.numTicks, 7);
            ++n;
        }
        this.paintThresholds(graphics);
        this.paintTickLabels(graphics);
    }

    protected void paintThresholds(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.floatThresholds.length) {
            graphics.setColor(this.floatThresholds[n3].colour);
            n2 = this.mapValuetoCoord(this.floatThresholds[n3].upTo);
            graphics.drawLine(n, 0, n2, 0);
            graphics.drawLine(n, 1, n2, 1);
            n = n2;
            ++n3;
        }
    }

    protected void paintTickLabels(Graphics graphics) {
        FontMetrics fontMetrics = this.controller.getFontMetrics(this.controller.getFont());
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 8 + fontMetrics.getMaxAscent();
        double d2 = this.max - this.min;
        graphics.setColor(this.controller.getForeground());
        if (this.numTicks == 0) {
            this.numTicks = 1;
        }
        int n4 = 0;
        while (n4 <= this.numTicks) {
            d = this.min + (double)n4 * d2 / (double)this.numTicks;
            n = (int)d;
            d = (double)((int)(d * 100.0)) / 100.0;
            String string = "";
            string = (double)n == d ? "" + n : "" + d;
            int n5 = fontMetrics.stringWidth(string);
            n2 = n4 == 0 ? 0 : (n4 == this.numTicks ? this.controller.getSize().width - n5 : this.controller.getSize().width * n4 / this.numTicks - n5 / 2);
            graphics.drawString(string, n2, n3);
            ++n4;
        }
    }
}

