/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclFuelGaugeDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.AccessibleEclFuelGaugeModel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGauge;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeView;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclFuelGaugeModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 6118245979950714498L;
    private transient EclFuelGauge controller;
    private String variableName;
    private Color colour;
    private int orientation;
    private int direction;
    private int border;

    public EclFuelGaugeModel() {
        this(null, EclFuelGaugeDefaults.barColour, 1, 0, 0);
    }

    public EclFuelGaugeModel(String string, Color color, int n, int n2, int n3) {
        this.variableName = string;
        this.colour = color;
        this.border = n;
        this.orientation = n2;
        this.direction = n3;
    }

    protected AccessibleEclFuelGaugeModel createAccessibleModel() {
        return new AccessibleEclFuelGaugeModel(this.variableName, this.colour, this.border, this.orientation, this.direction, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclFuelGaugeDefaults.background);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclFuelGaugeDefaults.foreground);
        }
        if (this.controller.getEclFuelGaugeView() == null) {
            this.controller.setEclFuelGaugeView(new EclFuelGaugeView(this.controller));
        }
        this.controller.getEclFuelGaugeView().initialise(this.colour, this.border, this.orientation, this.direction);
    }

    public void finishInitialise() {
        if (this.variableName != null) {
            ApplicationManager.instance().request("ISS", 0, this.variableName, (ApplicationObjectObserver)this.controller);
        }
    }

    private EclFuelGauge getController() {
        return this.controller;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void initialiseDefaults() {
        this.controller.setBackground(EclFuelGaugeDefaults.background);
        this.controller.setForeground(EclFuelGaugeDefaults.foreground);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.variableName = (String)objectInputStream.readObject();
                this.colour = (Color)objectInputStream.readObject();
                this.orientation = objectInputStream.readInt();
                this.direction = objectInputStream.readInt();
                this.border = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclProgressBarModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclFuelGauge eclFuelGauge) {
        this.controller = eclFuelGauge;
    }

    public String toString() {
        return "[" + (this.variableName == null ? "null" : this.variableName) + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.variableName);
        objectOutputStream.writeObject(this.colour);
        objectOutputStream.writeInt(this.orientation);
        objectOutputStream.writeInt(this.direction);
        objectOutputStream.writeInt(this.border);
    }
}

