/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.AccessibleEclFuelGaugeModel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGauge;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.preview.JColorChooser;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EclFuelGaugeModelWindow
extends Panel {
    private EclFuelGauge theComponentForModel;
    private JPanel ivjCenterPanel = null;
    private JTextField ivjVariableText = null;
    private JLabel ivjVariableNameLabel = null;
    private JLabel ivjBarColourLabel = null;
    private Choice ivjDirectionChoice = null;
    private JLabel ivjDirectionLabel = null;
    private Choice ivjOrientationChoice = null;
    private JLabel ivjOrientationLabel = null;
    private boolean initFlag = false;
    private String[] orientationChoices = new String[]{"Horizontal", "Vertical"};
    private String[] directionChoices = new String[]{"Positive", "Negative"};
    private String[] borderChoices = new String[]{"None", "Flat", "Sunken"};
    private JButton ivjColourButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);
    private Choice ivjBorderChoice = null;
    private JLabel ivjBorderLabel = null;

    public EclFuelGaugeModelWindow() {
        this.initialize();
    }

    public void colourButton_ActionPerformed() {
        JPanel jPanel = new JPanel();
        Color color = this.getColourButton().getBackground();
        Color color2 = JColorChooser.showDialog((Component)jPanel, (String)"Select threshold colour", (Color)color);
        if (color2 != null) {
            this.getColourButton().setBackground(color2);
            this.getColourButton().repaint();
        }
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.colourButton_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private JLabel getBarColourLabel() {
        if (this.ivjBarColourLabel == null) {
            try {
                this.ivjBarColourLabel = new JLabel();
                this.ivjBarColourLabel.setName("BarColourLabel");
                this.ivjBarColourLabel.setFont(new Font("dialog", 1, 12));
                this.ivjBarColourLabel.setText("Bar colour");
                this.ivjBarColourLabel.setBounds(5, 32, 91, 15);
                this.ivjBarColourLabel.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBarColourLabel;
    }

    private Choice getBorderChoice() {
        if (this.ivjBorderChoice == null) {
            try {
                this.ivjBorderChoice = new Choice();
                this.ivjBorderChoice.setName("BorderChoice");
                this.ivjBorderChoice.setBounds(101, 54, 177, 22);
                this.ivjBorderChoice.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBorderChoice;
    }

    private JLabel getBorderLabel() {
        if (this.ivjBorderLabel == null) {
            try {
                this.ivjBorderLabel = new JLabel();
                this.ivjBorderLabel.setName("BorderLabel");
                this.ivjBorderLabel.setFont(new Font("dialog", 1, 12));
                this.ivjBorderLabel.setText("Border");
                this.ivjBorderLabel.setBounds(5, 58, 91, 15);
                this.ivjBorderLabel.setEnabled(true);
                this.ivjBorderLabel.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBorderLabel;
    }

    private static void getBuilderData() {
    }

    private JPanel getCenterPanel() {
        if (this.ivjCenterPanel == null) {
            try {
                this.ivjCenterPanel = new JPanel();
                this.ivjCenterPanel.setName("CenterPanel");
                this.ivjCenterPanel.setLayout(null);
                this.getCenterPanel().add((Component)this.getVariableNameLabel(), this.getVariableNameLabel().getName());
                this.getCenterPanel().add((Component)this.getVariableText(), this.getVariableText().getName());
                this.getCenterPanel().add((Component)this.getBarColourLabel(), this.getBarColourLabel().getName());
                this.getCenterPanel().add((Component)this.getOrientationChoice(), this.getOrientationChoice().getName());
                this.getCenterPanel().add((Component)this.getDirectionChoice(), this.getDirectionChoice().getName());
                this.getCenterPanel().add((Component)this.getOrientationLabel(), this.getOrientationLabel().getName());
                this.getCenterPanel().add((Component)this.getDirectionLabel(), this.getDirectionLabel().getName());
                this.getCenterPanel().add((Component)this.getColourButton(), this.getColourButton().getName());
                this.getCenterPanel().add((Component)this.getBorderLabel(), this.getBorderLabel().getName());
                this.getCenterPanel().add((Component)this.getBorderChoice(), this.getBorderChoice().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCenterPanel;
    }

    private JButton getColourButton() {
        if (this.ivjColourButton == null) {
            try {
                this.ivjColourButton = new JButton();
                this.ivjColourButton.setName("ColourButton");
                this.ivjColourButton.setText("");
                this.ivjColourButton.setBounds(101, 30, 59, 19);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjColourButton;
    }

    private Choice getDirectionChoice() {
        if (this.ivjDirectionChoice == null) {
            try {
                this.ivjDirectionChoice = new Choice();
                this.ivjDirectionChoice.setName("DirectionChoice");
                this.ivjDirectionChoice.setBounds(101, 110, 177, 22);
                this.ivjDirectionChoice.setEnabled(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDirectionChoice;
    }

    private JLabel getDirectionLabel() {
        if (this.ivjDirectionLabel == null) {
            try {
                this.ivjDirectionLabel = new JLabel();
                this.ivjDirectionLabel.setName("DirectionLabel");
                this.ivjDirectionLabel.setFont(new Font("dialog", 1, 12));
                this.ivjDirectionLabel.setText("Direction");
                this.ivjDirectionLabel.setBounds(5, 114, 91, 15);
                this.ivjDirectionLabel.setEnabled(false);
                this.ivjDirectionLabel.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDirectionLabel;
    }

    private Choice getOrientationChoice() {
        if (this.ivjOrientationChoice == null) {
            try {
                this.ivjOrientationChoice = new Choice();
                this.ivjOrientationChoice.setName("OrientationChoice");
                this.ivjOrientationChoice.setBounds(101, 82, 177, 22);
                this.ivjOrientationChoice.setEnabled(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOrientationChoice;
    }

    private JLabel getOrientationLabel() {
        if (this.ivjOrientationLabel == null) {
            try {
                this.ivjOrientationLabel = new JLabel();
                this.ivjOrientationLabel.setName("OrientationLabel");
                this.ivjOrientationLabel.setFont(new Font("dialog", 1, 12));
                this.ivjOrientationLabel.setText("Orientation");
                this.ivjOrientationLabel.setBounds(5, 86, 91, 15);
                this.ivjOrientationLabel.setEnabled(false);
                this.ivjOrientationLabel.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOrientationLabel;
    }

    public EclFuelGaugeModel getTheNewModel() {
        String string = this.getVariableText().getText();
        Color color = this.getColourButton().getBackground();
        int n = this.getBorderChoice().getSelectedIndex();
        int n2 = this.getOrientationChoice().getSelectedIndex();
        int n3 = this.getDirectionChoice().getSelectedIndex();
        return new EclFuelGaugeModel(string, color, n, n2, n3);
    }

    private JLabel getVariableNameLabel() {
        if (this.ivjVariableNameLabel == null) {
            try {
                this.ivjVariableNameLabel = new JLabel();
                this.ivjVariableNameLabel.setName("VariableNameLabel");
                this.ivjVariableNameLabel.setFont(new Font("dialog", 1, 12));
                this.ivjVariableNameLabel.setText("Variable name");
                this.ivjVariableNameLabel.setBounds(5, 8, 91, 15);
                this.ivjVariableNameLabel.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjVariableNameLabel;
    }

    private JTextField getVariableText() {
        if (this.ivjVariableText == null) {
            try {
                this.ivjVariableText = new JTextField();
                this.ivjVariableText.setName("VariableText");
                this.ivjVariableText.setBounds(101, 6, 177, 19);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjVariableText;
    }

    private void handleException(Throwable throwable) {
    }

    private void initChoices() {
        int n = 0;
        while (n < this.orientationChoices.length) {
            this.getOrientationChoice().add(this.orientationChoices[n]);
            ++n;
        }
        n = 0;
        while (n < this.directionChoices.length) {
            this.getDirectionChoice().add(this.directionChoices[n]);
            ++n;
        }
        n = 0;
        while (n < this.borderChoices.length) {
            this.getBorderChoice().add(this.borderChoices[n]);
            ++n;
        }
        this.initFlag = true;
    }

    private void initConnections() throws Exception {
        this.getColourButton().addActionListener((ActionListener)this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("EclLabelPropertyEditor");
            this.setLayout(new BorderLayout());
            this.setSize(286, 139);
            this.add((Component)this.getCenterPanel(), "Center");
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Frame frame = new Frame();
            EclFuelGaugeModelWindow eclFuelGaugeModelWindow = new EclFuelGaugeModelWindow();
            frame.add("Center", eclFuelGaugeModelWindow);
            ((Component)frame).setSize(eclFuelGaugeModelWindow.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of java.awt.Panel");
            throwable.printStackTrace(System.out);
        }
    }

    public void setTheNewModel(EclFuelGaugeModel eclFuelGaugeModel) {
        if (!this.initFlag) {
            this.initChoices();
        }
        AccessibleEclFuelGaugeModel accessibleEclFuelGaugeModel = eclFuelGaugeModel.createAccessibleModel();
        this.theComponentForModel = accessibleEclFuelGaugeModel.getController();
        if (accessibleEclFuelGaugeModel.getVariableName() != null) {
            this.getVariableText().setText(accessibleEclFuelGaugeModel.getVariableName());
        }
        this.getOrientationChoice().select(accessibleEclFuelGaugeModel.getOrientation());
        this.getDirectionChoice().select(accessibleEclFuelGaugeModel.getDirection());
        this.getColourButton().setBackground(accessibleEclFuelGaugeModel.getColour());
        this.getBorderChoice().select(accessibleEclFuelGaugeModel.getBorder());
    }

    static JButton access$getColourButton(EclFuelGaugeModelWindow eclFuelGaugeModelWindow) {
        return eclFuelGaugeModelWindow.getColourButton();
    }

    static void access$connEtoC1(EclFuelGaugeModelWindow eclFuelGaugeModelWindow, ActionEvent actionEvent) {
        eclFuelGaugeModelWindow.connEtoC1(actionEvent);
    }

    class IvjEventHandler
    implements ActionListener {
        /* synthetic */ EclFuelGaugeModelWindow this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == EclFuelGaugeModelWindow.access$getColourButton(this.this$0)) {
                EclFuelGaugeModelWindow.access$connEtoC1(this.this$0, actionEvent);
            }
        }

        IvjEventHandler(EclFuelGaugeModelWindow eclFuelGaugeModelWindow) {
            this.this$0 = eclFuelGaugeModelWindow;
        }
    }
}

