/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.fuelgauge;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGauge;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.Beans;

public class EclFuelGaugeView
implements EclipseView {
    private EclFuelGauge controller;
    private double value = 0.0;
    private Color colour = null;
    private int border = 2;
    private int orientation = 0;
    private int direction = 0;

    public EclFuelGaugeView(EclFuelGauge eclFuelGauge) {
        this.controller = eclFuelGauge;
        if (this.controller != null) {
            this.notifyEclipseComponentChanged();
        } else {
            System.out.println("Null controller in EclFuelGaugeView constructor!");
        }
    }

    private Color getColor() {
        if (this.controller.getAxis() == null || this.controller.getAxis().getEclFuelGaugeAxisView().getColorForValue(this.value) == null) {
            return this.colour;
        }
        return this.controller.getAxis().getEclFuelGaugeAxisView().getColorForValue(this.value);
    }

    private double getMax() {
        if (this.controller.getAxis() != null) {
            return this.controller.getAxis().getEclFuelGaugeAxisView().getMax();
        }
        return 100.0;
    }

    private double getMin() {
        if (this.controller.getAxis() != null) {
            return this.controller.getAxis().getEclFuelGaugeAxisView().getMin();
        }
        return 0.0;
    }

    private int getOrientation() {
        if (this.controller.getAxis() != null) {
            return this.controller.getAxis().getEclFuelGaugeAxisView().getOrientation();
        }
        return this.orientation;
    }

    public double getValue() {
        return this.value;
    }

    protected void initialise(Color color, int n, int n2, int n3) {
        this.colour = color;
        this.border = n;
        this.orientation = n2;
        this.direction = n3;
        this.controller.repaint();
    }

    public void notifyEclipseComponentChanged() {
    }

    public void paint(Graphics graphics) {
        int n = (int)((this.value - this.getMin()) * (double)this.controller.getSize().width / (this.getMax() - this.getMin()));
        if (n > this.controller.getSize().width) {
            n = this.controller.getSize().width;
        }
        if (this.controller.getBackground() != null) {
            graphics.setColor(this.controller.getBackground());
            graphics.fillRect(0, 0, this.controller.getSize().width, this.controller.getSize().height);
        }
        graphics.setColor(this.getColor());
        graphics.fillRect(0, 0, n, this.controller.getSize().height);
        this.paintBorder(graphics);
    }

    private void paintBorder(Graphics graphics) {
        switch (this.border) {
            case 0: {
                if (!Beans.isDesignTime()) {
                    return;
                }
                graphics.setColor(this.controller.getVisibleBackground().darker());
                graphics.drawRect(0, 0, this.controller.getSize().width - 1, this.controller.getSize().height - 1);
                break;
            }
            case 1: {
                graphics.setColor(this.controller.getForeground());
                graphics.drawRect(0, 0, this.controller.getSize().width - 1, this.controller.getSize().height - 1);
                break;
            }
            case 2: {
                graphics.setColor(this.controller.getVisibleBackground().darker());
                graphics.drawLine(0, 0, this.controller.getSize().width - 1, 0);
                graphics.drawLine(0, 0, 0, this.controller.getSize().height - 1);
                graphics.setColor(this.controller.getVisibleBackground().brighter());
                graphics.drawLine(this.controller.getSize().width - 1, 0, this.controller.getSize().width - 1, this.controller.getSize().height - 1);
                graphics.drawLine(0, this.controller.getSize().height - 1, this.controller.getSize().width - 1, this.controller.getSize().height - 1);
                break;
            }
        }
    }

    public void setValue(double d) {
        if (this.value != d) {
            this.value = d;
            this.controller.repaint();
        }
    }

    public void setValue(float f) {
        this.setValue((double)f);
    }

    public void setValue(int n) {
        this.setValue((double)n);
    }
}

