/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.label;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLabelDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelView;
import java.awt.Color;
import java.beans.Beans;

public class EclLabel
extends EclipseComponent
implements CcGreyableComponent,
MaskedIntegerDataReceiver,
CompositeDataReceiver {
    private EclLabelModel eclModel;
    private transient ApplicationObject theTextSelectionApplicationObject = null;
    private transient ApplicationObject theGreyApplicationObject = null;
    private transient EclLabelView eclView;
    private transient MaskedIntegerValue thePreviousStandardValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean trappedCompositeDataError = true;
    private transient boolean isInitialChange;

    public EclLabel() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.isInitialChange = true;
            switch (this.eclModel.getPropertyIDForName(applicationObject.getName())) {
                case 11: {
                    this.theTextSelectionApplicationObject = applicationObject;
                    break;
                }
                case 12: {
                    this.theGreyApplicationObject = applicationObject;
                }
            }
        }
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclLabelDefaults.transientErrorColour : super.getBackground();
    }

    protected EclipseView getEclipseView() {
        return this.getEclLabelView();
    }

    EclLabelView getEclLabelView() {
        return this.eclView;
    }

    public EclLabelModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclLabelModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    void permanentError() {
        this.setBackground(EclLabelDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theTextSelectionApplicationObject) {
            this.trappedCompositeDataError = !compositeData.update(this.getEclModel().getCompositeDataID(), this.getEclLabelView(), this.isInitialChange);
            this.isInitialChange = false;
            if (this.hasTrappedTransientError) {
                this.testForValidity();
            } else {
                this.trapTransientError(this.trappedCompositeDataError);
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theTextSelectionApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousStandardValue)) {
                this.thePreviousStandardValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedViewWithNewStandard(this.thePreviousStandardValue));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclLabelView(EclLabelView eclLabelView) {
        this.eclView = eclLabelView;
    }

    public void setEclModel(EclLabelModel eclLabelModel) {
        this.eclModel = eclLabelModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
    }

    private void testForValidity() {
        if (this.getEclModel().getCompositeDataID() == -1) {
            if (this.getEclModel().updatedGreyValue(this.thePreviousGreyValue) && this.getEclModel().updatedViewWithNewStandard(this.thePreviousStandardValue)) {
                this.trapTransientError(false);
                this.repaint();
            }
        } else if (!this.trappedCompositeDataError && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclLabel" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theTextSelectionApplicationObject != null) {
            this.theTextSelectionApplicationObject.unregister(this);
            this.theTextSelectionApplicationObject = null;
            this.thePreviousStandardValue = null;
            this.trappedCompositeDataError = true;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

