/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.label;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLabelDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.label.AccessibleEclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclLabelModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -8442401396171493718L;
    private String databaseGreyVariable;
    private String databaseStandardVariable;
    private String[][] textStandards;
    private int compositeDataId;
    private transient EclLabel controller;

    public EclLabelModel() {
        this.databaseGreyVariable = null;
        this.databaseStandardVariable = null;
        this.textStandards = new String[][]{{"Txt"}};
        this.compositeDataId = -1;
    }

    public EclLabelModel(String string, String string2) {
        this.textStandards = new String[][]{{string}};
        this.databaseGreyVariable = string2;
        this.databaseStandardVariable = null;
        this.compositeDataId = -1;
    }

    public EclLabelModel(String string, String string2, String[][] stringArray) {
        this.textStandards = stringArray;
        this.databaseGreyVariable = string2;
        this.databaseStandardVariable = string;
        this.compositeDataId = -1;
    }

    public EclLabelModel(String string, String string2, String[][] stringArray, int n) {
        this.textStandards = stringArray;
        this.databaseGreyVariable = string2;
        this.databaseStandardVariable = string;
        this.compositeDataId = n;
    }

    private boolean areStandardValuesConsistent(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseStandardVariable != null && (maskedIntegerValue == null || maskedIntegerValue.getValue() < 0 || maskedIntegerValue.getValue() > this.textStandards.length - 1)) {
            bl = false;
        }
        return bl;
    }

    protected AccessibleEclLabelModel createAccessibleModel() {
        return new AccessibleEclLabelModel(this.databaseStandardVariable, this.databaseGreyVariable, this.textStandards, this.compositeDataId, this.getController());
    }

    public void createView() {
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclLabelDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclLabelDefaults.font);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclLabelDefaults.foreground);
        }
        if (this.getController().getEclLabelView() == null) {
            this.getController().setEclLabelView(new EclLabelView(this.getController()));
        }
        if (this.compositeDataId == -1) {
            if (this.databaseStandardVariable == null) {
                this.getController().getEclLabelView().setTextProperty(this.textStandards[0][0]);
            } else {
                this.getController().getEclLabelView().setTextProperty(this.textStandards[0][1]);
            }
        } else {
            this.getController().getEclLabelView().setTextProperty(this.textStandards[0][0]);
        }
    }

    public void finishInitialise() {
        if (this.databaseGreyVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.getController());
        }
        if (this.databaseStandardVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseStandardVariable, (ApplicationObjectObserver)this.getController());
        } else {
            if (this.databaseGreyVariable == null) {
                this.getController().trapTransientError(false);
            }
            this.getController().setGreying(false, false);
        }
    }

    int getCompositeDataID() {
        return this.compositeDataId;
    }

    private EclLabel getController() {
        return this.controller;
    }

    int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseStandardVariable)) {
            n = 11;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.getController().setFont(EclLabelDefaults.font);
        this.getController().setForeground(EclLabelDefaults.foreground);
        this.getController().setBackground(EclLabelDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.textStandards = new String[][]{{(String)objectInputStream.readObject()}};
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 1: {
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.textStandards = (String[][])objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 2: {
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.textStandards = (String[][])objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclLabelModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclLabel eclLabel) {
        this.controller = eclLabel;
    }

    public String toString() {
        return "[" + (this.databaseStandardVariable == null ? "null" : this.databaseStandardVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + (this.compositeDataId == -1 ? "" : ", " + this.compositeDataId) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    public boolean updatedViewWithNewStandard(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.areStandardValuesConsistent(maskedIntegerValue)) {
            String string = maskedIntegerValue == null ? this.textStandards[0][0] : this.textStandards[maskedIntegerValue.getValue()][1];
            this.getController().getEclLabelView().setTextProperty(string);
        } else {
            bl = false;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(this.databaseStandardVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeObject(this.textStandards);
        objectOutputStream.writeInt(this.compositeDataId);
    }
}

