/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.label;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.ColorPropertiesAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class EclLabelView
implements EclipseView,
TextPropertyAccessor,
ColorPropertiesAccessor {
    private EclLabel theController;
    private String theText = null;
    private Point theTextOrigin = new Point(0, 0);

    public EclLabelView(EclLabel eclLabel) {
        this.theController = eclLabel;
        if (this.theController != null) {
            this.notifyEclipseComponentChanged();
        }
    }

    private Color getTextColor() {
        return this.theController.isEnabled() ? this.theController.getForeground() : Color.gray;
    }

    public String getTextProperty() {
        return this.theText;
    }

    public void notifyEclipseComponentChanged() {
        FontMetrics fontMetrics = null;
        if (this.theController.getFont() != null) {
            fontMetrics = this.theController.getFontMetrics(this.theController.getFont());
        }
        if (fontMetrics != null) {
            Rectangle rectangle = this.theController.getBounds();
            int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.theTextOrigin.x = 0;
            this.theTextOrigin.y = (rectangle.height - n) / 2 + fontMetrics.getMaxAscent();
        }
    }

    public void paint(Graphics graphics) {
        if (this.theController.getBackground() != null) {
            graphics.setColor(this.theController.getBackground());
            graphics.fillRect(0, 0, this.theController.getBounds().width, this.theController.getBounds().height);
        }
        graphics.setColor(this.getTextColor());
        graphics.setFont(this.theController.getFont());
        graphics.drawString(this.theText, this.theTextOrigin.x, this.theTextOrigin.y);
    }

    public void repaint() {
        if (this.theController != null) {
            this.theController.repaint();
        }
    }

    public boolean setBackground(Color color) {
        this.theController.setBackground(color);
        return true;
    }

    public boolean setForeground(Color color) {
        this.theController.setForeground(color);
        return true;
    }

    public boolean setTextProperty(String string) {
        if (string != null) {
            this.theText = string;
            return true;
        }
        return false;
    }
}

