/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.led;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLedDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLedModel;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLedView;
import java.awt.Color;
import java.beans.Beans;

public class EclLed
extends EclipseComponent
implements KnownLengthStringDataReceiver,
CcConnectedComponent {
    private EclLedModel eclModel = null;
    private transient EclLedView eclView = null;
    private transient ApplicationObject theApplicationObject = null;
    private transient boolean hasTrappedTransientError = false;
    private transient KnownLengthStringValue thePreviousStringValue = null;
    public static final transient int LED_RED = 0;
    public static final transient int LED_AMBER = 1;
    public static final transient int LED_GREEN = 2;
    public static final transient int LED_RED_GREEN = 3;

    public EclLed() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(12, 12);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclLedDefaults.transientErrorColour : super.getBackground();
    }

    protected EclipseView getEclipseView() {
        return this.eclView;
    }

    public EclLedView getEclLedView() {
        return this.eclView;
    }

    public EclLedModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclLedModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    protected void initialiseModel() {
        EclLedModel eclLedModel = this.getEclModel();
        if (this.eclView == null) {
            eclLedModel.createView();
        }
    }

    void permanentError() {
        this.setBackground(EclLedDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue knownLengthStringValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!knownLengthStringValue.equals(this.thePreviousStringValue)) {
                this.thePreviousStringValue = knownLengthStringValue;
                if (knownLengthStringValue.getValue().equals("0")) {
                    this.trapTransientError(this.getEclLedView().setValue(0));
                } else if (knownLengthStringValue.getValue().equals("1")) {
                    this.trapTransientError(this.getEclLedView().setValue(1));
                } else if (knownLengthStringValue.getValue().equals("2")) {
                    this.trapTransientError(this.getEclLedView().setValue(2));
                } else {
                    this.trapTransientError(true);
                }
                this.repaint();
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclLedView(EclLedView eclLedView) {
        this.eclView = eclLedView;
    }

    public void setEclModel(EclLedModel eclLedModel) {
        this.eclModel = eclLedModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclLed" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousStringValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

