/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.led;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLedDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.led.AccessibleEclLedModel;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLed;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLedView;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclLedModel
implements EclipseModel,
Serializable {
    private transient EclLed controller;
    private String variableName;
    private int colour;
    private int diameter;
    static final long serialVersionUID = -6253215432862380367L;

    public EclLedModel() {
        this(null, 0);
    }

    public EclLedModel(String string, int n) {
        this.variableName = string;
        this.colour = n;
        this.diameter = 12;
    }

    public EclLedModel(String string, int n, int n2) {
        this.variableName = string;
        this.colour = n;
        this.diameter = n2;
    }

    protected AccessibleEclLedModel createAccessibleModel() {
        return new AccessibleEclLedModel(this.variableName, this.colour, this.diameter, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclLedDefaults.background);
        }
        this.controller.setEclLedView(new EclLedView(this.getColourWhenON(), this.diameter, this.controller));
    }

    public void finishInitialise() {
        if (this.variableName == null) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " requires a variable name");
            this.getController().permanentError();
        } else {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.variableName, (ApplicationObjectObserver)this.controller);
        }
    }

    private Color[] getColourWhenON() {
        switch (this.colour) {
            case 0: {
                return new Color[]{EclLedDefaults.redColour};
            }
            case 1: {
                return new Color[]{EclLedDefaults.amberColour};
            }
            case 2: {
                return new Color[]{EclLedDefaults.greenColour};
            }
            case 3: {
                return new Color[]{EclLedDefaults.redColour, EclLedDefaults.greenColour};
            }
        }
        return new Color[]{EclLedDefaults.redColour};
    }

    private EclLed getController() {
        return this.controller;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void initialiseDefaults() {
        this.controller.setBackground(EclLedDefaults.background);
        this.controller.setFont(new Font("dialog", 0, 12));
        this.controller.setForeground(Color.black);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: 
            case 1: {
                this.variableName = (String)objectInputStream.readObject();
                this.colour = objectInputStream.readInt();
                this.diameter = 12;
                break;
            }
            case 2: {
                this.variableName = (String)objectInputStream.readObject();
                this.colour = objectInputStream.readInt();
                this.diameter = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclLedModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclLed eclLed) {
        this.controller = eclLed;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        stringBuffer.append(this.variableName == null ? "null" : this.variableName);
        stringBuffer.append(", ");
        switch (this.colour) {
            case 0: {
                stringBuffer.append("Red");
                break;
            }
            case 1: {
                stringBuffer.append("Amber");
                break;
            }
            case 2: {
                stringBuffer.append("Green");
                break;
            }
            case 3: {
                stringBuffer.append("Red Green");
                break;
            }
            default: {
                stringBuffer.append("Unknown colour type");
            }
        }
        if (this.diameter != 12) {
            stringBuffer.append(", ");
            stringBuffer.append(this.diameter);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(this.variableName);
        objectOutputStream.writeInt(this.colour);
        objectOutputStream.writeInt(this.diameter);
    }
}

