/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.led;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLed;
import java.awt.Color;
import java.awt.Graphics;

public class EclLedView
implements EclipseView {
    private EclLed controller;
    private int value = -1;
    private Color[] colour = null;
    private int diameter = 0;

    public EclLedView(Color[] colorArray, int n, EclLed eclLed) {
        this.colour = colorArray;
        this.controller = eclLed;
        this.diameter = n;
        if (this.controller != null) {
            this.notifyEclipseComponentChanged();
        } else {
            System.out.println("Null controller in EclLedView constructor!");
        }
    }

    private Color getCurrentColor() {
        Color color = null;
        switch (this.value) {
            case 0: {
                color = this.controller.getVisibleBackground().darker();
                break;
            }
            case 1: {
                color = this.colour[0];
                break;
            }
            case 2: {
                if (this.colour.length == 2) {
                    color = this.colour[1];
                    break;
                }
                color = this.controller.getVisibleBackground().darker();
                break;
            }
            default: {
                color = this.controller.getVisibleBackground().darker();
            }
        }
        return color;
    }

    public void notifyEclipseComponentChanged() {
    }

    public void paint(Graphics graphics) {
        if (this.controller.getBackground() != null) {
            graphics.setColor(this.controller.getBackground());
            graphics.fillRect(0, 0, this.diameter, this.diameter);
        }
        graphics.setColor(this.getCurrentColor());
        graphics.fillOval(0, 0, this.diameter, this.diameter);
        graphics.setColor(Color.white);
        graphics.drawArc(2, 2, this.diameter - 4, this.diameter - 4, 90, 90);
    }

    public boolean setValue(int n) {
        this.value = n;
        return n < 0 || n > this.colour.length;
    }
}

