/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.line;

import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLineDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.Beans;

public class EclLine
extends Component {
    public static final int ORIENT_HORIZONTAL = 0;
    public static final int ORIENT_VERTICAL = 1;
    public static final int ORIENT_NW_SE = 2;
    public static final int ORIENT_NE_SW = 3;
    public static final int STYLE_FLAT = 0;
    public static final int STYLE_RAISED = 1;
    public static final int STYLE_SUNKEN = 2;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_START = 1;
    public static final int ARROW_END = 2;
    public static final int ARROW_BOTH = 3;
    private int thickness = 1;
    private int orientation = 0;
    private int style = 0;
    private int arrowStyle = 0;
    private int arrowLength = 7;
    private int arrowWidth = 5;
    private transient Point startPoint = new Point(0, 0);
    private transient Point endPoint = new Point(0, 0);
    private transient int[] startArrowXPoints = new int[]{0, 0, 0, 0};
    private transient int[] startArrowYPoints = new int[]{0, 0, 0, 0};
    private transient int[] endArrowXPoints = new int[]{0, 0, 0, 0};
    private transient int[] endArrowYPoints = new int[]{0, 0, 0, 0};
    private transient boolean stackHoriz = false;
    private transient Color highlight = Color.white;
    private transient Color shadow = Color.black;
    private transient boolean colourFlag = false;

    public EclLine() {
        this.setForeground(EclLineDefaults.foreground);
        this.setBackground(EclLineDefaults.background);
        this.setSize(70, 20);
        this.calculateGeometry();
    }

    private void calculateArrowGeometry() {
        if (this.style != 0) {
            return;
        }
        if (this.arrowStyle == 1 || this.arrowStyle == 3) {
            if (this.orientation == 0) {
                this.startArrowXPoints[0] = 0;
                this.startArrowYPoints[0] = this.startPoint.y - this.arrowWidth + (this.thickness + 2 * this.arrowWidth + 1) / 2 - 1;
                this.startArrowXPoints[1] = this.arrowLength - 1;
                this.startArrowYPoints[1] = this.startPoint.y - this.arrowWidth;
                this.startArrowXPoints[2] = this.arrowLength - 1;
                this.startArrowYPoints[2] = this.startPoint.y + this.arrowWidth + this.thickness - 1;
                this.startArrowXPoints[3] = 0;
                this.startArrowYPoints[3] = this.startPoint.y - this.arrowWidth + (this.thickness + 2 * this.arrowWidth) / 2;
                this.startPoint.x = this.arrowLength - 1;
            } else if (this.orientation == 1) {
                this.startArrowXPoints[0] = this.startPoint.x - this.arrowWidth + (this.thickness + 2 * this.arrowWidth + 1) / 2 - 1;
                this.startArrowYPoints[0] = 0;
                this.startArrowXPoints[1] = this.startPoint.x - this.arrowWidth;
                this.startArrowYPoints[1] = this.arrowLength - 1;
                this.startArrowXPoints[2] = this.startPoint.x + this.arrowWidth + this.thickness - 1;
                this.startArrowYPoints[2] = this.arrowLength - 1;
                this.startArrowXPoints[3] = this.startPoint.x - this.arrowWidth + (this.thickness + 2 * this.arrowWidth) / 2;
                this.startArrowYPoints[3] = 0;
                this.startPoint.y = this.arrowLength - 1;
            }
        }
        if (this.arrowStyle == 2 || this.arrowStyle == 3) {
            if (this.orientation == 0) {
                this.endArrowXPoints[0] = this.endPoint.x;
                this.endArrowYPoints[0] = this.endPoint.y - this.arrowWidth + (this.thickness + 2 * this.arrowWidth + 1) / 2 - 1;
                this.endArrowXPoints[1] = this.endPoint.x - this.arrowLength + 1;
                this.endArrowYPoints[1] = this.endPoint.y - this.arrowWidth;
                this.endArrowXPoints[2] = this.endPoint.x - this.arrowLength + 1;
                this.endArrowYPoints[2] = this.endPoint.y + this.arrowWidth + this.thickness - 1;
                this.endArrowXPoints[3] = this.endPoint.x;
                this.endArrowYPoints[3] = this.endPoint.y - this.arrowWidth + (this.thickness + 2 * this.arrowWidth) / 2;
                this.endPoint.x -= this.arrowLength;
            } else if (this.orientation == 1) {
                this.endArrowXPoints[0] = this.endPoint.x - this.arrowWidth + (this.thickness + 2 * this.arrowWidth + 1) / 2 - 1;
                this.endArrowYPoints[0] = this.endPoint.y;
                this.endArrowXPoints[1] = this.endPoint.x - this.arrowWidth;
                this.endArrowYPoints[1] = this.endPoint.y - this.arrowLength + 1;
                this.endArrowXPoints[2] = this.endPoint.x + this.arrowWidth + this.thickness - 1;
                this.endArrowYPoints[2] = this.endPoint.y - this.arrowLength + 1;
                this.endArrowXPoints[3] = this.endPoint.x - this.arrowWidth + (this.thickness + 2 * this.arrowWidth) / 2;
                this.endArrowYPoints[3] = this.endPoint.y;
                this.endPoint.y -= this.arrowLength;
            }
        }
    }

    private void calculateColours() {
        switch (this.style) {
            case 0: {
                this.highlight = this.getForeground();
                this.shadow = this.getForeground();
                break;
            }
            case 1: 
            case 2: {
                this.highlight = this.getVisibleBackground().brighter();
                this.shadow = this.getVisibleBackground().darker();
            }
        }
        this.colourFlag = true;
    }

    private void calculateGeometry() {
        this.colourFlag = false;
        this.calculateLineGeometry();
        this.calculateArrowGeometry();
    }

    private void calculateLineGeometry() {
        switch (this.orientation) {
            case 0: {
                this.startPoint.x = 0;
                this.startPoint.y = this.getSize().height / 2;
                this.endPoint.x = this.getSize().width - 1;
                this.endPoint.y = this.startPoint.y;
                this.stackHoriz = false;
                this.startPoint.y -= this.thickness / 2;
                this.endPoint.y -= this.thickness / 2;
                break;
            }
            case 1: {
                this.startPoint.x = this.getSize().width / 2;
                this.startPoint.y = 0;
                this.endPoint.x = this.startPoint.x;
                this.endPoint.y = this.getSize().height - 1;
                this.stackHoriz = true;
                this.startPoint.x -= this.thickness / 2;
                this.endPoint.x -= this.thickness / 2;
                break;
            }
            case 3: {
                this.startPoint.x = this.getSize().width - 1;
                this.startPoint.y = 0;
                this.endPoint.x = 0;
                this.endPoint.y = this.getSize().height - 1;
                this.stackHoriz = this.startPoint.x < this.endPoint.y;
                this.startPoint.x -= this.thickness / 2;
                this.startPoint.y -= this.thickness / 2;
                this.endPoint.x -= this.thickness / 2;
                this.endPoint.y -= this.thickness / 2;
                break;
            }
            case 2: {
                this.startPoint.x = 0;
                this.startPoint.y = 0;
                this.endPoint.x = this.getSize().width - 1;
                this.endPoint.y = this.getSize().height - 1;
                this.stackHoriz = this.endPoint.x < this.endPoint.y;
                this.startPoint.x -= this.thickness / 2;
                this.startPoint.y -= this.thickness / 2;
                this.endPoint.x -= this.thickness / 2;
                this.endPoint.y -= this.thickness / 2;
            }
        }
    }

    public int getArrowLength() {
        return this.arrowLength;
    }

    public int getArrowStyle() {
        return this.arrowStyle;
    }

    public int getArrowWidth() {
        return this.arrowWidth;
    }

    public Color getBackground() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getBackground();
    }

    private Color getFirstColour() {
        if (this.style == 0) {
            return this.getForeground();
        }
        switch (this.orientation) {
            case 0: 
            case 1: 
            case 3: {
                return this.style == 1 ? this.highlight : this.shadow;
            }
            case 2: {
                if (this.stackHoriz) {
                    return this.style == 1 ? this.shadow : this.highlight;
                }
                return this.style == 1 ? this.highlight : this.shadow;
            }
        }
        return this.getForeground();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.thickness, this.thickness);
    }

    private Color getSecondColour() {
        if (this.style == 0) {
            return this.getForeground();
        }
        switch (this.orientation) {
            case 0: 
            case 1: 
            case 3: {
                return this.style == 1 ? this.shadow : this.highlight;
            }
            case 2: {
                if (this.stackHoriz) {
                    return this.style == 1 ? this.highlight : this.shadow;
                }
                return this.style == 1 ? this.shadow : this.highlight;
            }
        }
        return this.getForeground();
    }

    public int getStyle() {
        return this.style;
    }

    public int getThickness() {
        return this.thickness;
    }

    public Color getVisibleBackground() {
        if (this.getBackground() != null) {
            return this.getBackground();
        }
        Container container = this.getParent();
        while (container != null) {
            if (container.getBackground() != null) {
                return container.getBackground();
            }
            container = container.getParent();
        }
        return Color.lightGray;
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime() || !this.colourFlag) {
            this.calculateColours();
        }
        this.paintLine(graphics);
        this.paintArrowheads(graphics);
    }

    private void paintArrowheads(Graphics graphics) {
        if (this.style != 0) {
            return;
        }
        if (this.orientation == 3 || this.orientation == 2) {
            return;
        }
        if (this.arrowStyle == 1 || this.arrowStyle == 3) {
            graphics.drawPolygon(this.startArrowXPoints, this.startArrowYPoints, 4);
            graphics.fillPolygon(this.startArrowXPoints, this.startArrowYPoints, 4);
        }
        if (this.arrowStyle == 3 || this.arrowStyle == 2) {
            graphics.drawPolygon(this.endArrowXPoints, this.endArrowYPoints, 4);
            graphics.fillPolygon(this.endArrowXPoints, this.endArrowYPoints, 4);
        }
    }

    private void paintLine(Graphics graphics) {
        int n = this.thickness;
        if (this.style != 0 && n % 2 == 1) {
            ++n;
        }
        if (this.stackHoriz) {
            graphics.setColor(this.getFirstColour());
            int n2 = 0;
            while (n2 < n / 2) {
                graphics.drawLine(this.startPoint.x + n2, this.startPoint.y, this.endPoint.x + n2, this.endPoint.y);
                ++n2;
            }
            graphics.setColor(this.getSecondColour());
            n2 = n / 2;
            while (n2 < n) {
                graphics.drawLine(this.startPoint.x + n2, this.startPoint.y, this.endPoint.x + n2, this.endPoint.y);
                ++n2;
            }
        } else {
            graphics.setColor(this.getFirstColour());
            int n3 = 0;
            while (n3 < n / 2) {
                graphics.drawLine(this.startPoint.x, this.startPoint.y + n3, this.endPoint.x, this.endPoint.y + n3);
                ++n3;
            }
            graphics.setColor(this.getSecondColour());
            n3 = n / 2;
            while (n3 < n) {
                graphics.drawLine(this.startPoint.x, this.startPoint.y + n3, this.endPoint.x, this.endPoint.y + n3);
                ++n3;
            }
        }
    }

    public void setArrowLength(int n) {
        this.arrowLength = n;
        this.calculateGeometry();
    }

    public void setArrowStyle(int n) {
        this.arrowStyle = n;
        this.calculateGeometry();
    }

    public void setArrowWidth(int n) {
        this.arrowWidth = n;
        this.calculateGeometry();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calculateGeometry();
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.calculateGeometry();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calculateGeometry();
    }

    public void setStyle(int n) {
        this.style = n;
        this.calculateGeometry();
    }

    public void setThickness(int n) {
        if (n < 1) {
            n = 1;
        }
        this.thickness = n;
        this.calculateGeometry();
    }
}

