/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.radiobutton;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclRadioButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.EclRadioButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.EclRadioButtonView;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;

public class EclRadioButton
extends EclipseComponent
implements CcGreyableComponent,
MaskedIntegerDataReceiver {
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient ApplicationObject errorMode = null;
    private transient EclRadioButtonView eclView = null;
    private EclRadioButtonModel eclModel = null;
    private transient boolean hasFocus = false;
    private transient int currentValue = -1;
    private transient int index = 0;
    private transient boolean unregistered = false;
    private transient boolean optionBit = true;
    private transient boolean stateBit = true;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclRadioButton() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
        this.enableEvents(12L);
        this.createMouseHandler();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.unregister();
            this.setGreying(true, true);
            this.setBackground(EclRadioButtonDefaults.permanentErrorColour);
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.unregister();
            this.setGreying(true, true);
            this.setBackground(EclRadioButtonDefaults.permanentErrorColour);
        } else {
            String string = applicationObject.getName();
            if (this.eclModel.getPropertyIDForName(string) == 10) {
                this.theApplicationObject = applicationObject;
            } else {
                this.theGreyApplicationObject = applicationObject;
            }
        }
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.unregistered = false;
        this.getEclModel().finishInitialise();
    }

    protected EclipseView getEclipseView() {
        return this.getEclRadioButtonView();
    }

    public EclRadioButtonModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclRadioButtonModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    EclRadioButtonView getEclRadioButtonView() {
        return this.eclView;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        EclRadioButtonModel eclRadioButtonModel = this.getEclModel();
        if (this.eclView == null) {
            eclRadioButtonModel.createView();
        }
    }

    public boolean isEnabled() {
        return this.stateBit && super.isEnabled();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isVisible() {
        return this.optionBit && super.isVisible();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclRadioButtonView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseHandler.processMouseEvent(mouseEvent, this.getEclRadioButtonView(), this.hasFocus, this.isEnabled());
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        int n = maskedIntegerValue.getValue();
        if (((ApplicationDataSender)this.theApplicationObject).equals(applicationDataSender)) {
            if (this.stateBit != maskedIntegerValue.getStateMask().query(this.index)) {
                this.stateBit = !this.stateBit;
                this.repaint();
            }
            if (this.optionBit != maskedIntegerValue.getOptionMask().query(this.index)) {
                this.optionBit = !this.optionBit;
                this.repaint();
            }
            if (n == this.index && n != this.currentValue) {
                this.getEclRadioButtonView().setSelected(true);
                this.currentValue = n;
                this.repaint();
            } else if (this.currentValue == this.index && n != this.currentValue) {
                this.getEclRadioButtonView().setSelected(false);
                this.currentValue = n;
                this.repaint();
            }
        } else if (this.theGreyApplicationObject != null && ((ApplicationDataSender)this.theGreyApplicationObject).equals(applicationDataSender)) {
            boolean bl;
            if (n != 0 && n != 1) {
                System.out.println("EclRadioButton '" + this.getName() + "' received a dodgy boolean");
                this.setBackground(EclRadioButtonDefaults.transientErrorColour);
                this.setGreying(false, true);
                return;
            }
            boolean bl2 = bl = n == 1;
            if (bl != super.isEnabled()) {
                this.setGreying(!bl, true);
            }
        }
    }

    public boolean select() {
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(this.index);
        if (this.theApplicationObject.change(maskedIntegerValue)) {
            this.currentValue = this.index;
            return true;
        }
        EclipseSystem.instance().beep();
        EventLog.instance().log(String.valueOf(this.toString()) + " Error: Requested change failed.");
        return false;
    }

    public void setEclModel(EclRadioButtonModel eclRadioButtonModel) {
        this.eclModel = eclRadioButtonModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclRadioButtonView(EclRadioButtonView eclRadioButtonView) {
        this.eclView = eclRadioButtonView;
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (super.isEnabled() == bl) {
            this.setEnabled(!bl);
            if (bl2) {
                this.repaint();
            }
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    protected void setIndex(int n) {
        this.index = n;
    }

    public void switchToErrorMode(ApplicationObject applicationObject) {
        this.errorMode = applicationObject;
    }

    public void trapTransientError(boolean bl) {
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
        }
        this.theApplicationObject = null;
        this.theGreyApplicationObject = null;
        this.errorMode = null;
        this.unregistered = true;
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
        }
    }
}

