/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.radiobutton;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclRadioButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.AccessibleEclRadioButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.EclRadioButton;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.EclRadioButtonView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclRadioButtonModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 7041185193309373874L;
    private String helpId = null;
    private String databaseVariable;
    private String databaseGreyVariable;
    private String text;
    private int value;
    private transient EclRadioButton controller;

    public EclRadioButtonModel() {
        this("EclRadioButton", null, null, 0);
    }

    public EclRadioButtonModel(String string, String string2, String string3, int n) {
        this.text = string;
        this.databaseVariable = string2;
        this.databaseGreyVariable = string3;
        this.value = n;
    }

    public EclRadioButtonModel(String string, String string2, String string3, int n, String string4) {
        this.text = string;
        this.databaseVariable = string2;
        this.databaseGreyVariable = string3;
        this.value = n;
        this.helpId = string4;
    }

    AccessibleEclRadioButtonModel createAccessibleModel() {
        return new AccessibleEclRadioButtonModel(this.databaseVariable, this.databaseGreyVariable, this.text, this.value, this.helpId, this.controller);
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclRadioButtonDefaults.background);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclRadioButtonDefaults.font);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclRadioButtonDefaults.foreground);
        }
        if (this.controller.getEclRadioButtonView() == null) {
            this.controller.setEclRadioButtonView(new EclRadioButtonView(this.controller));
        }
        this.controller.getEclRadioButtonView().setText(this.text);
    }

    public void finishInitialise() {
        if (this.databaseVariable == null) {
            System.out.println("EclRadioButton '" + this.controller.getName() + "' requires a 'value' variable name");
            this.controller.setGreying(true, true);
            this.controller.setBackground(EclRadioButtonDefaults.permanentErrorColour);
            return;
        }
        ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseVariable, (ApplicationObjectObserver)this.controller);
        if (this.databaseGreyVariable != null) {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.controller);
        }
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclRadioButtonDefaults.font);
        this.controller.setForeground(EclRadioButtonDefaults.foreground);
        this.controller.setBackground(EclRadioButtonDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.value = objectInputStream.readInt();
                break;
            }
            case 1: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.value = objectInputStream.readInt();
                this.helpId = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclRadioButtonModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclRadioButton eclRadioButton) {
        this.controller = eclRadioButton;
        this.controller.setIndex(this.value);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.text);
        objectOutputStream.writeObject(this.databaseVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeInt(this.value);
        objectOutputStream.writeObject(this.helpId);
    }
}

