/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.radiobutton;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclRadioButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.components.radiobutton.EclRadioButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;

public class EclRadioButtonView
implements EclipseView,
MouseActionnedComponent {
    private EclRadioButton controller;
    private String text;
    private boolean selected;
    private Point textOrigin;
    private Point iconOrigin;
    private boolean geometrySet;
    private static final int ICON_SIZE = 12;
    private static final int ICON_GAP = 2;
    private static final int TEXT_GAP = 5;
    private static UnconsumedKeyHandler theMainKeyController = null;

    protected EclRadioButtonView(EclRadioButton eclRadioButton) {
        this.controller = eclRadioButton;
        this.textOrigin = new Point(0, 0);
        this.iconOrigin = new Point(0, 0);
        this.setText("");
        this.setSelected(false);
        this.updateGeometry();
    }

    private void action() {
        if (!this.selected && this.controller.select()) {
            this.selected = true;
            this.repaint();
        }
    }

    public void doLeftClickAction() {
        this.action();
    }

    public void doRightClickAction() {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.controller), this.controller);
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclRadioButtonView.theMainKeyController != null) break block2;
            var1_1 = this.controller.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.controller.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclRadioButtonView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclRadioButtonView.theMainKeyController;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void notifyEclipseComponentChanged() {
        this.updateGeometry();
    }

    public void paint(Graphics graphics) {
        if (this.controller.getBackground() != null) {
            graphics.setColor(this.controller.getBackground());
            graphics.fillRect(0, 0, this.controller.getSize().width, this.controller.getSize().height);
        }
        this.paintRadioIcon(graphics, this.iconOrigin.x, this.iconOrigin.y);
        graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.controller.getVisibleBackground().darker());
        graphics.drawString(this.text, this.textOrigin.x, this.textOrigin.y);
        if (this.controller.hasFocus()) {
            graphics.setColor(EclRadioButtonDefaults.focusColour);
            graphics.drawRect(0, 0, this.controller.getSize().width - 1, this.controller.getSize().height - 1);
        }
    }

    public void paintRadioIcon(Graphics graphics, int n, int n2) {
        graphics.setColor(this.controller.getVisibleBackground().darker());
        graphics.fillArc(n, n2, 12, 12, 45, 180);
        graphics.setColor(Color.white);
        graphics.fillArc(n, n2, 12, 12, 225, 180);
        graphics.setColor(Color.black);
        graphics.fillArc(n + 1, n2 + 1, 10, 10, 45, 180);
        graphics.setColor(this.controller.getVisibleBackground());
        graphics.fillArc(n + 1, n2 + 1, 10, 10, 225, 180);
        graphics.setColor(this.controller.isEnabled() ? Color.white : this.controller.getVisibleBackground());
        graphics.fillOval(n + 2, n2 + 2, 9, 9);
        if (this.isSelected()) {
            graphics.setColor(this.controller.isEnabled() ? Color.black : Color.gray);
            graphics.fillOval(n + 4, n2 + 4, 5, 5);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: {
                    this.action();
                }
                case 0: {
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.controller);
        }
    }

    public void repaint() {
        this.controller.repaint();
    }

    public void requestFocus() {
        this.controller.requestFocus();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setText(String string) {
        this.text = string;
    }

    protected void updateGeometry() {
        int n = this.controller.getSize().height;
        Font font = this.controller.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.controller.getFontMetrics(font);
            this.iconOrigin.x = 2;
            this.iconOrigin.y = (n - 12) / 2;
            this.textOrigin.x = 19;
            this.textOrigin.y = (n - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2;
            this.textOrigin.y += fontMetrics.getAscent();
        }
    }
}

