/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.stringlist;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataGroup;
import com.agilent.tntd.eclipse.common.data.ApplicationDataGroupReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SelectedStringObserver;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceButtonListView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceController;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclStringListDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.components.stringlist.EclStringListModel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.ListIterator;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;

public class EclStringList
extends EclipseComponent
implements CcGreyableComponent,
ApplicationDataGroupReceiver,
SingleSelectableChoiceController {
    private transient ApplicationObject theListApplicationObject;
    private transient ApplicationObject theIndexApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasFocus = false;
    private transient SingleSelectableChoiceView eclView = null;
    private EclStringListModel eclModel;
    private transient ApplicationDataGroup previousGroup = null;
    private transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient ApplicationDataGroup thePreviousListValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient List selectedStringObservers = null;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclStringList() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
        this.enableEvents(12L);
        this.createMouseHandler();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            switch (this.eclModel.getPropertyIDForName(string)) {
                case 10: {
                    this.theIndexApplicationObject = applicationObject;
                    break;
                }
                case 11: {
                    this.theListApplicationObject = applicationObject;
                    break;
                }
                default: {
                    this.theGreyApplicationObject = applicationObject;
                }
            }
        }
    }

    private void createListForView() {
        GreyableString[] greyableStringArray = new GreyableString[this.thePreviousListValue.getGroup().size()];
        int n = 0;
        while (n < greyableStringArray.length) {
            greyableStringArray[n] = new GreyableString((String)this.thePreviousListValue.getGroup().get(n), true);
            ++n;
        }
        this.getEclStringListView().initialiseView(greyableStringArray);
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclStringListDefaults.transientErrorColour : super.getBackground();
    }

    protected EclipseView getEclipseView() {
        return this.getEclStringListView();
    }

    public EclStringListModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclStringListModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    SingleSelectableChoiceView getEclStringListView() {
        return this.eclView;
    }

    public boolean hasFocus() {
        return this.hasFocus || this.getEclStringListView() != null && this.getEclStringListView().hasFocus();
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void notifyObservers(GreyableString greyableString) {
        if (this.selectedStringObservers != null) {
            ListIterator listIterator = this.selectedStringObservers.listIterator();
            while (listIterator.hasNext()) {
                ((SelectedStringObserver)listIterator.next()).updateSelectedString(greyableString);
            }
        }
    }

    void permanentError() {
        this.setBackground(EclStringListDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        switch (n) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclStringListView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseHandler.processMouseEvent(mouseEvent, this.getEclStringListView().getMouseActionnedComponent(), this.hasFocus, this.isEnabled());
    }

    public void receiveApplicationDataGroup(ApplicationDataGroup applicationDataGroup, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theListApplicationObject) {
            if (!applicationDataGroup.equals(this.thePreviousListValue)) {
                this.thePreviousListValue = applicationDataGroup;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.createListForView();
                    this.trapTransientError(!this.getEclStringListView().setSelectedIndex(this.thePreviousIndexValue.getValue(), false));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theIndexApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                this.thePreviousIndexValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclStringListView().setSelectedIndex(maskedIntegerValue.getValue(), false));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void register(SelectedStringObserver selectedStringObserver) {
        if (this.selectedStringObservers == null) {
            this.selectedStringObservers = Collections.synchronizedList((List)new ArrayList());
        }
        this.selectedStringObservers.add((Object)selectedStringObserver);
        selectedStringObserver.updateSelectedString(((SingleSelectableChoiceButtonListView)this.eclView).getSelectedString());
    }

    public void setEclModel(EclStringListModel eclStringListModel) {
        this.eclModel = eclStringListModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclStringListView(SingleSelectableChoiceView singleSelectableChoiceView) {
        this.eclView = singleSelectableChoiceView;
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void setSelectedIndex(int n) {
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n, this.thePreviousIndexValue);
        if (!this.theIndexApplicationObject.change(maskedIntegerValue)) {
            EclipseSystem.instance().beep();
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: Requested change failed.");
            this.getEclStringListView().setSelectedIndex(this.thePreviousIndexValue.getValue(), false);
        }
    }

    public void setSelectedString(GreyableString greyableString) {
        this.notifyObservers(greyableString);
    }

    private void testForValidity() {
        if (this.thePreviousIndexValue != null && this.thePreviousListValue != null && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.createListForView();
            this.trapTransientError(!this.getEclStringListView().setSelectedIndex(this.thePreviousIndexValue.getValue(), false));
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclStringList" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theListApplicationObject != null) {
            this.theListApplicationObject.unregister(this);
            this.theListApplicationObject = null;
            this.thePreviousListValue = null;
        }
        if (this.theIndexApplicationObject != null) {
            this.theIndexApplicationObject.unregister(this);
            this.theIndexApplicationObject = null;
            this.thePreviousIndexValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void unregister(SelectedStringObserver selectedStringObserver) {
        if (this.selectedStringObservers == null) {
            return;
        }
        this.selectedStringObservers.remove((Object)selectedStringObserver);
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

