/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.stringlist;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceButtonListView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclStringListDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.stringlist.AccessibleEclStringListModel;
import com.agilent.tntd.eclipse.viewlayer.components.stringlist.EclStringList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclStringListModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 3922606366210088574L;
    private String helpId = null;
    private String databaseListVariable;
    private String databaseIndexVariable;
    private String databaseGreyVariable;
    private transient EclStringList controller;

    public EclStringListModel() {
        this(null, null, null);
    }

    public EclStringListModel(String string, String string2, String string3) {
        this.databaseListVariable = string;
        this.databaseIndexVariable = string2;
        this.databaseGreyVariable = string3;
    }

    public EclStringListModel(String string, String string2, String string3, String string4) {
        this.databaseListVariable = string;
        this.databaseIndexVariable = string2;
        this.databaseGreyVariable = string3;
        this.helpId = string4;
    }

    AccessibleEclStringListModel createAccessibleModel() {
        return new AccessibleEclStringListModel(this.databaseListVariable, this.databaseIndexVariable, this.databaseGreyVariable, this.helpId, this.controller);
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclStringListDefaults.background);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclStringListDefaults.font);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclStringListDefaults.foreground);
        }
        if (this.controller.getEclStringListView() == null) {
            this.controller.setEclStringListView(new SingleSelectableChoiceButtonListView(this.controller));
        }
    }

    public void finishInitialise() {
        if (this.databaseListVariable == null || this.databaseIndexVariable == null) {
            EventLog.instance().log(String.valueOf(this.controller.toString()) + " requires a list and index variable names");
            this.controller.permanentError();
        } else {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseListVariable, (ApplicationObjectObserver)this.controller);
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseIndexVariable, (ApplicationObjectObserver)this.controller);
            if (this.databaseGreyVariable != null) {
                ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.controller);
            }
        }
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseIndexVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        } else if (string.equals(this.databaseListVariable)) {
            n = 11;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclStringListDefaults.font);
        this.controller.setForeground(EclStringListDefaults.foreground);
        this.controller.setBackground(EclStringListDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.databaseListVariable = (String)objectInputStream.readObject();
                this.databaseIndexVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                break;
            }
            case 1: {
                this.databaseListVariable = (String)objectInputStream.readObject();
                this.databaseIndexVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.helpId = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclStringListModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclStringList eclStringList) {
        this.controller = eclStringList;
    }

    public String toString() {
        return "[" + (this.databaseListVariable == null ? "null" : this.databaseListVariable) + ", " + (this.databaseIndexVariable == null ? "null" : this.databaseIndexVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.controller.setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.controller.setGreying(false, false);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.databaseListVariable);
        objectOutputStream.writeObject(this.databaseIndexVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeObject(this.helpId);
    }
}

