/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.TableLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableView;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionEvent;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionEventMulticaster;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionListener;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;

public class EclTable
extends EclipseContainer
implements CcComponent {
    private static final int NAVIGATION_NOT_ALLOWED = -1;
    private static final int FOCUS_NAVIGATION = 0;
    private static final int TABLE_NAVIGATION = 1;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private EclTableModel eclModel = null;
    private ArrayList myColumnList = null;
    private transient EclTableView eclView = null;
    private transient Font myFont = null;
    private transient Color myForegroundColor = null;
    private transient boolean hasFocus = false;
    private transient int navigationMode = -1;
    private transient int focusIndex = -1;
    private transient int maxIndex = -1;
    private transient int selectedIndex = -1;
    protected transient RowSelectionListener aRowSelectionListener = null;
    private transient ContextHelpController contextHelpController = null;

    public EclTable() {
        this.initialize();
    }

    private void actionDownKey() {
        this.setFocusIndex(this.focusIndex + 1);
    }

    private void actionUpKey() {
        if (this.focusIndex <= 0) {
            return;
        }
        this.setFocusIndex(this.focusIndex - 1);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof EclTableColumn) {
            this.myColumnList.add((Object)component);
            if (this.getEclModel() != null) {
                this.getEclModel().initialiseColumn((EclTableColumn)component);
            }
        }
    }

    public void addRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this.aRowSelectionListener = RowSelectionEventMulticaster.add(this.aRowSelectionListener, rowSelectionListener);
    }

    void calculateMaxIndex() {
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(0);
            this.maxIndex = eclTableColumn.getColumnBodyComponentCount() - 1;
            int n = 1;
            while (n < this.myColumnList.size()) {
                eclTableColumn = (EclTableColumn)this.myColumnList.get(n);
                int n2 = eclTableColumn.getColumnBodyComponentCount();
                this.maxIndex = n2 - 1 < this.maxIndex ? n2 - 1 : this.maxIndex;
                ++n;
            }
        }
        if (this.focusIndex > this.maxIndex) {
            this.setFocusIndex(-1);
        }
        if (this.selectedIndex > this.maxIndex) {
            this.setSelectedIndex(-1);
        }
    }

    public void finishInitialise() {
        if (this.getEclModel() != null) {
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < this.getComponentCount()) {
                if (componentArray[n] instanceof CcComponent) {
                    ((CcComponent)((Object)componentArray[n])).finishInitialise();
                }
                ++n;
            }
            if (this.isFocusTraversable()) {
                this.navigationMode = 0;
            }
            this.validate();
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " requires a model to initialise its columns.");
            this.permanentError();
        }
    }

    protected void fireSelectRow(RowSelectionEvent rowSelectionEvent) {
        if (this.aRowSelectionListener == null) {
            return;
        }
        this.aRowSelectionListener.selectRow(rowSelectionEvent);
    }

    private ContextHelpController getContextHelpController() {
        if (this.contextHelpController == null) {
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof ContextHelpController) {
                    this.contextHelpController = (ContextHelpController)((Object)container);
                    break;
                }
                container = container.getParent();
            }
        }
        return this.contextHelpController;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.getEclTableView();
    }

    public EclTableModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclTableModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
            this.updateColumns();
        }
        return this.eclModel;
    }

    public EclTableView getEclTableView() {
        return this.eclView;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getForeground() {
        return this.myForegroundColor;
    }

    /*
     * Unable to fully structure code
     */
    UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclTable.theMainKeyController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclTable.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclTable.theMainKeyController;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        EclTableModel eclTableModel = this.getEclModel();
        if (this.getEclTableView() == null) {
            eclTableModel.createView();
        }
    }

    private void initialize() {
        this.enableEvents(12L);
        this.setLayout(new TableLayout());
        this.myColumnList = new ArrayList();
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
    }

    public boolean isFocusTraversable() {
        return this.getEclModel().isFocusable();
    }

    private void permanentError() {
        this.setBackground(EclTableDefaults.permanentErrorColour);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        switch (n) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                this.getContextHelpController().displayContextHelp("TableHelpId");
                break;
            }
            case 1005: {
                this.hasFocus = false;
                this.getContextHelpController().removeContextHelp("TableHelpId");
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            if (this.navigationMode == 1) {
                switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                    case 10: {
                        this.getContextHelpController().displayContextHelp("TableHelpId");
                        this.navigationMode = 0;
                        this.setSelectedIndex();
                        this.fireSelectRow(new RowSelectionEvent(this));
                        this.setFocusIndex(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 27: {
                        this.getContextHelpController().displayContextHelp("TableHelpId");
                        this.navigationMode = 0;
                        this.setFocusIndex(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        this.actionDownKey();
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        this.actionUpKey();
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        keyEvent.consume();
                        break;
                    }
                }
            } else if (this.navigationMode == 0) {
                switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                    case 10: {
                        if (this.maxIndex > -1) {
                            this.navigationMode = 1;
                            this.setFocusIndex(0);
                            this.getContextHelpController().displayContextHelp("RowHelpId");
                        }
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this);
                        break;
                    }
                }
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": processKeyEvent: Unknown navigation mode");
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            if (GenericMouseHelper.isLeftMouseButton(mouseEvent) && this.isFocusTraversable()) {
                int n;
                this.requestFocus();
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                Component component = this.getComponentAt(n2, n3);
                if (component instanceof EclTableColumn && (n = ((EclTableColumn)component).getIndexOfComponentAt(n2 - component.getLocation().x, n3 - component.getLocation().y)) != -1) {
                    this.setSelectedIndex(n);
                    this.fireSelectRow(new RowSelectionEvent(this));
                }
            } else if (GenericMouseHelper.isRightMouseButton(mouseEvent)) {
                if (this.isFocusTraversable()) {
                    this.requestFocus();
                }
                this.processKeyEvent(InstrumentKeyMappings.getMenuKeyEvent(this));
            }
        }
    }

    public void removeNotify() {
        this.hasFocus = false;
        super.removeNotify();
    }

    public void removeRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this.aRowSelectionListener = RowSelectionEventMulticaster.remove(this.aRowSelectionListener, rowSelectionListener);
    }

    public void setEclModel(EclTableModel eclTableModel) {
        this.eclModel = eclTableModel;
        if (this.eclModel != null) {
            if (this.eclModel.isFocusable()) {
                this.enableEvents(16L);
            }
            this.eclModel.setController(this);
            this.eclModel.createView();
            this.updateColumns();
        }
    }

    public void setEclTableView(EclTableView eclTableView) {
        this.eclView = eclTableView;
    }

    public void setFocusIndex(int n) {
        if (n < -1 || n > this.maxIndex) {
            return;
        }
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            this.focusIndex = n;
            int n2 = 0;
            while (n2 < this.myColumnList.size()) {
                EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(n2);
                eclTableColumn.setFocusIndex(this.focusIndex);
                ++n2;
            }
        }
    }

    public void setFont(Font font) {
        this.myFont = font;
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setForeground(Color color) {
        this.myForegroundColor = color;
        super.setForeground(color);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setSelectedIndex() {
        this.setSelectedIndex(this.focusIndex);
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n > this.maxIndex) {
            return;
        }
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            this.selectedIndex = n;
            int n2 = 0;
            while (n2 < this.myColumnList.size()) {
                EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(n2);
                eclTableColumn.setSelectedIndex(this.selectedIndex);
                ++n2;
            }
            this.fireSelectRow(new RowSelectionEvent(this));
        }
    }

    public String toString() {
        String string = this.getName();
        return string == null || string.length() == 0 ? "EclTable" : string;
    }

    public void unregister() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    void updateColumns() {
        int n = 0;
        while (n < this.myColumnList.size()) {
            this.getEclModel().initialiseColumn((EclTableColumn)this.myColumnList.get(n));
            ++n;
        }
    }
}

