/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataGroup;
import com.agilent.tntd.eclipse.common.data.ApplicationDataGroupReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.ColumnLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumnModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumnView;
import com.agilent.tntd.eclipse.viewlayer.components.table.TableColumnComponent;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.Beans;

public class EclTableColumn
extends EclipseContainer
implements CcGreyableComponent,
ApplicationDataGroupReceiver {
    private EclTableColumnModel eclModel = null;
    private transient ApplicationObject theAppObject;
    private transient ApplicationDataGroup thePreviousGroupValue;
    private transient ApplicationObject theGreyAppObject;
    private transient MaskedIntegerValue thePreviousGreyValue;
    private transient EclTableColumnView eclView = null;
    private transient boolean hasTrappedTransientError = false;
    private transient String DomainName = "ISS";

    public EclTableColumn() {
        this.initialize();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Initialization failed because " + applicationObject.toString() + " failed to initialize.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Initialization failed because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            if (this.getEclModel().getPropertyIDForName(string) == 10) {
                this.theAppObject = applicationObject;
            } else {
                this.theGreyAppObject = applicationObject;
            }
        }
    }

    public void finishInitialise() {
        String string = this.getEclModel().getDatabaseVariableName();
        if (string != null && !string.equalsIgnoreCase("")) {
            this.trapTransientError(true);
        }
        this.getEclModel().finishInitialise();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).finishInitialise();
            }
            ++n;
        }
        this.validate();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclTableDefaults.transientErrorColour : super.getBackground();
    }

    public TableColumnComponent getColumnBodyComponentAt(int n) {
        return this.getEclTableColumnView().getColumnBodyComponentAt(n);
    }

    public int getColumnBodyComponentCount() {
        return this.getEclTableColumnView().getColumnBodyComponentCount();
    }

    public String getDomainName() {
        return this.DomainName;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.getEclTableColumnView();
    }

    public EclTableColumnModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclTableColumnModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public EclTableColumnView getEclTableColumnView() {
        return this.eclView;
    }

    protected int getIndexOfComponentAt(int n, int n2) {
        Component[] componentArray = this.getComponents();
        int n3 = 2;
        while (n3 < componentArray.length) {
            int n4 = componentArray[n3].getLocation().x;
            int n5 = componentArray[n3].getLocation().y;
            if (componentArray[n3].contains(n - n4, n2 - n5)) {
                return n3 - 2;
            }
            ++n3;
        }
        return -1;
    }

    protected void initialiseModel() {
        EclTableColumnModel eclTableColumnModel = this.getEclModel();
        if (this.getEclTableColumnView() == null) {
            eclTableColumnModel.createView();
        }
    }

    private void initialize() {
        this.setLayout(new ColumnLayout());
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.invalidate();
    }

    public void initialize(Color color, Color color2, Font font, boolean bl, Color color3, boolean bl2, int n) {
        this.setForeground(color);
        this.setBackground(color2);
        this.setFont(font);
        if (this.getEclTableColumnView() != null) {
            this.getEclTableColumnView().initialise(bl, color3, bl2, n);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": initialize: requires an initialised model.");
            this.permanentError();
        }
    }

    void permanentError() {
        this.setBackground(EclTableDefaults.permanentErrorColour);
        this.trapTransientError(false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void receiveApplicationDataGroup(ApplicationDataGroup applicationDataGroup, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theAppObject) {
            if (!applicationDataGroup.equals(this.thePreviousGroupValue)) {
                this.getEclTableColumnView().populateBody(applicationDataGroup.getEnumeration());
                this.trapTransientError(false);
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + " receiveApplicationDataGroup: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    public void setContents(List list) {
        this.invalidate();
        this.getEclTableColumnView().populateBody(list.iterator());
        this.trapTransientError(false);
    }

    public void setDomainName(String string) {
        this.DomainName = string;
    }

    public void setEclModel(EclTableColumnModel eclTableColumnModel) {
        this.eclModel = eclTableColumnModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclTableColumnView(EclTableColumnView eclTableColumnView) {
        this.eclView = eclTableColumnView;
    }

    void setFocusIndex(int n) {
        this.getEclTableColumnView().setFocusIndex(n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
    }

    void setSelectedIndex(int n) {
        this.getEclTableColumnView().setSelectedIndex(n);
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclTableColumn" : string;
        return String.valueOf(string2) + ": " + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            if (bl) {
                this.setGreying(true, false);
            } else {
                this.setGreying(false, false);
            }
        }
    }

    public void unregister() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
        if (this.theAppObject != null) {
            this.theAppObject.unregister(this);
            this.theAppObject = null;
            this.thePreviousGroupValue = null;
        }
        if (this.theGreyAppObject != null) {
            this.theGreyAppObject.unregister(this);
            this.theGreyAppObject = null;
            this.thePreviousGreyValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": update: The interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString() + " has not been implemented.");
            this.permanentError();
        }
    }
}

