/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table.AccessibleEclTableColumnModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumnView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclTableColumnModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -6610735955483079518L;
    private String dbVariable;
    private String dbGreyVariable;
    private String headerText;
    private String bodyText;
    private transient EclTableColumn controller;

    public EclTableColumnModel() {
        this(null, null, "Undefined", "Sample Text");
    }

    public EclTableColumnModel(String string, String string2, String string3, String string4) {
        this.dbVariable = string;
        this.dbGreyVariable = string2;
        this.headerText = string3;
        this.bodyText = string4;
    }

    AccessibleEclTableColumnModel createAccessibleModel() {
        return new AccessibleEclTableColumnModel(this.dbVariable, this.dbGreyVariable, this.headerText, this.bodyText, this.controller);
    }

    public void createView() {
        if (this.controller.getEclTableColumnView() == null) {
            this.controller.setEclTableColumnView(new EclTableColumnView(this.controller));
        }
        this.controller.getEclTableColumnView().setHeaderText(this.headerText);
        this.controller.getEclTableColumnView().setBodyText(this.bodyText);
    }

    public void finishInitialise() {
        if (this.dbVariable != null) {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.dbVariable, (ApplicationObjectObserver)this.controller, null);
        }
        if (this.dbGreyVariable != null) {
            EventLog.instance().log("INFO: " + this.controller.toString() + ": finishInitialise: Grey variable not supported.");
            this.controller.permanentError();
        }
    }

    String getDatabaseVariableName() {
        return this.dbVariable;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.dbVariable)) {
            n = 10;
        } else if (string.equals(this.dbGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclTableDefaults.font);
        this.controller.setForeground(EclTableDefaults.foreground);
        this.controller.setBackground(EclTableDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.dbVariable = (String)objectInputStream.readObject();
                this.dbGreyVariable = (String)objectInputStream.readObject();
                this.headerText = (String)objectInputStream.readObject();
                this.bodyText = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclTableColumnModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclTableColumn eclTableColumn) {
        this.controller = eclTableColumn;
    }

    public String toString() {
        return "[" + (this.headerText == null ? "No Header" : this.headerText) + ", " + (this.dbVariable == null ? "null" : this.dbVariable) + ", " + (this.dbGreyVariable == null ? "null" : this.dbGreyVariable) + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.dbVariable);
        objectOutputStream.writeObject(this.dbGreyVariable);
        objectOutputStream.writeObject(this.headerText);
        objectOutputStream.writeObject(this.bodyText);
    }
}

