/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.line.EclLine;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTable;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table.TableColumnComponent;
import com.agilent.tntd.eclipse.viewlayer.components.table.TableColumnLabel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.Beans;

public class EclTableColumnView
implements EclipseContainerView {
    private String headerText;
    private String bodyText;
    private Color lineColor;
    private int numTestRows;
    private boolean drawLines;
    private boolean drawHeader;
    private transient EclLabel columnHeader = null;
    private transient EclLine columnLine = null;
    private transient ArrayList columnComponents = null;
    private transient EclTableColumn controller = null;
    private transient int focusIndex = -1;
    private transient int selectedIndex = -1;

    public EclTableColumnView(EclTableColumn eclTableColumn) {
        this.controller = eclTableColumn;
        if (eclTableColumn == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": Constructor: Null controller in constructor! Unable to initialize.");
        }
    }

    void addColumnBodyComponent(TableColumnComponent tableColumnComponent) {
        this.columnComponents.add((Object)tableColumnComponent);
        this.controller.add((Component)((Object)tableColumnComponent));
    }

    private void createColumn() {
        this.controller.removeAll();
        this.columnComponents = new ArrayList();
        if (this.drawHeader) {
            this.createHeader();
        }
        if (Beans.isDesignTime()) {
            this.populateBody(this.numTestRows);
        }
    }

    private void createHeader() {
        this.columnHeader = new TableColumnLabel();
        this.columnHeader.setEclModel(new EclLabelModel(null, null, new String[][]{{"  " + this.headerText}}));
        Font font = this.getFont();
        this.columnHeader.setFont(new Font(font.getName(), 1, font.getSize()));
        this.columnHeader.setForeground(this.getForeground());
        this.columnLine = new EclLine();
        this.columnLine.setThickness(2);
        this.columnLine.setForeground(this.lineColor);
        this.controller.add(this.columnHeader);
        this.controller.add(this.columnLine);
    }

    private Color getBackground() {
        return this.controller.getBackground();
    }

    TableColumnComponent getColumnBodyComponentAt(int n) {
        if (this.columnComponents != null && n > -1 && n < this.columnComponents.size()) {
            return (TableColumnComponent)this.columnComponents.get(n);
        }
        return null;
    }

    int getColumnBodyComponentCount() {
        int n = 0;
        if (this.columnComponents != null) {
            n = this.columnComponents.size();
        }
        return n;
    }

    private Font getFont() {
        return this.controller.getFont();
    }

    private Color getForeground() {
        return this.controller.getForeground();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void initialise(boolean bl, Color color, boolean bl2, int n) {
        this.drawHeader = bl;
        this.lineColor = color;
        this.drawLines = bl2;
        this.numTestRows = n;
        this.createColumn();
        if (this.columnLine != null) {
            this.columnLine.setForeground(color);
        }
        if (Beans.isDesignTime()) {
            this.populateBody(n);
        }
    }

    public void notifyEclipseContainerChanged() {
        this.updateFont();
        this.updateForeground();
        this.controller.validate();
        this.controller.repaint();
    }

    public void paintAfterChildren(Graphics graphics) {
        if (Beans.isDesignTime() && (this.getBackground() == null || this.getBackground().equals(this.controller.getParent().getBackground()))) {
            if (this.controller.getParent().getBackground() == Color.lightGray) {
                graphics.setColor(Color.darkGray);
            } else {
                graphics.setColor(Color.lightGray);
            }
            graphics.drawRect(0, 0, this.controller.getBounds().width - 1, this.controller.getBounds().height - 1);
        }
    }

    public void paintBeforeChildren(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.controller.getBounds().width, this.controller.getBounds().height);
        }
    }

    private void populateBody(int n) {
        this.removeAllColumnBodyComponents();
        int n2 = 0;
        while (n2 < n) {
            TableColumnLabel tableColumnLabel = new TableColumnLabel();
            tableColumnLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{"  " + this.bodyText}}));
            this.addColumnBodyComponent(tableColumnLabel);
            ++n2;
        }
        if (this.controller.getParent() != null) {
            this.controller.getParent().validate();
        }
        this.notifyEclipseContainerChanged();
    }

    void populateBody(Iterator iterator) {
        Container container = this.controller.getParent();
        this.removeAllColumnBodyComponents();
        if (iterator != null) {
            int n = 0;
            while (iterator.hasNext()) {
                TableColumnLabel tableColumnLabel = new TableColumnLabel();
                tableColumnLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{"  " + iterator.next().toString()}}));
                if (n == this.selectedIndex) {
                    tableColumnLabel.setSelected(true);
                }
                this.addColumnBodyComponent(tableColumnLabel);
                ++n;
            }
        }
        this.controller.doLayout();
        if (container != null) {
            if (container instanceof EclTable) {
                ((EclTable)container).calculateMaxIndex();
            }
            container.doLayout();
        }
        this.notifyEclipseContainerChanged();
    }

    void removeAllColumnBodyComponents() {
        int n = 0;
        while (n < this.getColumnBodyComponentCount()) {
            this.controller.remove((Component)((Object)this.getColumnBodyComponentAt(n)));
            ++n;
        }
        this.columnComponents = new ArrayList();
    }

    void setBodyText(String string) {
        this.bodyText = string;
        if (this.columnComponents != null) {
            TableColumnComponent tableColumnComponent = null;
            int n = 0;
            while (n < this.columnComponents.size()) {
                tableColumnComponent = this.getColumnBodyComponentAt(n);
                if (tableColumnComponent instanceof EclLabel) {
                    ((EclLabel)((Object)tableColumnComponent)).setEclModel(new EclLabelModel(null, null, new String[][]{{this.bodyText}}));
                }
                ++n;
            }
        }
    }

    void setFocusIndex(int n) {
        if (this.focusIndex != n) {
            TableColumnComponent tableColumnComponent;
            if (this.focusIndex >= 0 && this.focusIndex < this.getColumnBodyComponentCount()) {
                tableColumnComponent = this.getColumnBodyComponentAt(this.focusIndex);
                tableColumnComponent.setFocus(false);
            }
            if (n >= 0 && n < this.getColumnBodyComponentCount()) {
                this.focusIndex = n;
                tableColumnComponent = this.getColumnBodyComponentAt(this.focusIndex);
                tableColumnComponent.setFocus(true);
            } else {
                this.focusIndex = -1;
            }
            this.notifyEclipseContainerChanged();
        }
    }

    void setHeaderText(String string) {
        this.headerText = string;
        if (this.columnHeader != null) {
            this.columnHeader.setEclModel(new EclLabelModel(null, null, new String[][]{{this.headerText}}));
        }
    }

    void setSelectedIndex(int n) {
        if (this.selectedIndex != n) {
            TableColumnComponent tableColumnComponent;
            if (this.selectedIndex >= 0 && this.selectedIndex < this.getColumnBodyComponentCount()) {
                tableColumnComponent = this.getColumnBodyComponentAt(this.selectedIndex);
                tableColumnComponent.setSelected(false);
            }
            if (n >= 0 && n < this.getColumnBodyComponentCount()) {
                this.selectedIndex = n;
                tableColumnComponent = this.getColumnBodyComponentAt(this.selectedIndex);
                tableColumnComponent.setSelected(true);
            } else {
                this.selectedIndex = -1;
            }
            this.notifyEclipseContainerChanged();
        }
    }

    public String toString() {
        String string = "";
        if (this.controller != null) {
            string = this.controller.getName();
        }
        String string2 = string.length() == 0 ? "EclTableColumnView" : String.valueOf(string) + " view";
        return string2;
    }

    private void updateFont() {
        Font font = this.controller.getFont();
        if (this.columnHeader != null) {
            this.columnHeader.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        int n = 0;
        while (n < this.getColumnBodyComponentCount()) {
            ((Component)((Object)this.getColumnBodyComponentAt(n))).setFont(font);
            ++n;
        }
    }

    private void updateForeground() {
        Color color = this.controller.getForeground();
        if (color != null) {
            if (this.columnHeader != null) {
                this.columnHeader.setForeground(color);
            }
            int n = 0;
            while (n < this.getColumnBodyComponentCount()) {
                ((Component)((Object)this.getColumnBodyComponentAt(n))).setForeground(color);
                ++n;
            }
        }
    }
}

