/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.Beans;

public class EclTableView
implements EclipseContainerView {
    private transient EclTable controller = null;
    private final Insets myInsets = new Insets(0, 0, 0, 0);

    public EclTableView(EclTable eclTable) {
        this.controller = eclTable;
        if (eclTable == null) {
            System.out.println("ERROR: " + this.toString() + ": Constructor: Null controller in constructor!");
        }
    }

    private Color getBackground() {
        return this.controller.getBackground();
    }

    private boolean getDrawBorder() {
        return this.controller.getEclModel().getDrawBorder();
    }

    private boolean getDrawLines() {
        return this.controller.getEclModel().getDrawLines();
    }

    private Color getForeground() {
        return this.controller.getForeground();
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    private Color getLineColor() {
        Color color = this.controller.getEclModel().getLineColor();
        if (color == null) {
            color = this.getForeground();
        }
        return color;
    }

    public boolean hasFocus() {
        return this.controller.hasFocus();
    }

    public void notifyEclipseContainerChanged() {
        this.controller.updateColumns();
        this.controller.validate();
    }

    public void paintAfterChildren(Graphics graphics) {
        if (this.getDrawLines()) {
            graphics.setColor(this.getLineColor());
            Component[] componentArray = this.controller.getComponents();
            int n = 0;
            while (n < componentArray.length - 1) {
                Rectangle rectangle = componentArray[n].getBounds();
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                ++n;
            }
        }
        if (this.getDrawBorder() || this.hasFocus()) {
            graphics.setColor(this.hasFocus() ? EclTableDefaults.focusColor : this.getForeground());
            graphics.drawRect(0, 0, this.controller.getBounds().width - 1, this.controller.getBounds().height - 1);
        } else if (Beans.isDesignTime() && (this.getBackground() == null || this.getBackground().equals(this.controller.getParent().getBackground()))) {
            if (this.controller.getParent().getBackground() == Color.lightGray) {
                graphics.setColor(Color.darkGray);
            } else {
                graphics.setColor(Color.lightGray);
            }
            graphics.drawRect(0, 0, this.controller.getBounds().width - 1, this.controller.getBounds().height - 1);
        }
    }

    public void paintBeforeChildren(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.controller.getBounds().width, this.controller.getBounds().height);
        }
    }
}

