/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table2;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.scroller.ScrollableObject;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.scroller.Scroller;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.TableLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableModel;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableView;
import com.agilent.tntd.eclipse.viewlayer.components.table2.RowSelectionEvent;
import com.agilent.tntd.eclipse.viewlayer.components.table2.RowSelectionEventMulticaster;
import com.agilent.tntd.eclipse.viewlayer.components.table2.RowSelectionListener;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclTable
extends EclipseContainer
implements CcConnectedComponent,
ApplicationGenericDataReceiver,
ScrollableObject {
    private static final int NAVIGATION_NOT_ALLOWED = -1;
    private static final int FOCUS_NAVIGATION = 0;
    private static final int TABLE_NAVIGATION = 1;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private EclTableModel eclModel = null;
    private ArrayList myColumnList = null;
    private ArrayList theParamList = null;
    private transient ApplicationObject theApplicationObject = null;
    private transient String DomainName = "ISS";
    private transient EclTableView eclView = null;
    private transient Font myFont = null;
    private transient Color myForegroundColor = null;
    private transient boolean hasFocus = false;
    private transient int navigationMode = -1;
    private transient int focusIndex = -1;
    private transient int maxIndex = -1;
    private transient int selectedIndex = -1;
    protected transient RowSelectionListener aRowSelectionListener = null;
    transient boolean hasTrappedTransientError = false;
    transient boolean hasTrappedPermanentError = false;
    private Scroller scroller = null;
    private int startIndex = 0;
    private boolean endOfDataReached = true;
    private transient ContextHelpController contextHelpController = null;

    public EclTable() {
        this.initialize();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (applicationObject.getName().equals(this.getEclModel().getDataVariableName())) {
            this.theApplicationObject = applicationObject;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + applicationObject.toString());
        }
    }

    private void actionDownKey() {
        this.setFocusIndex(this.focusIndex + 1, true);
    }

    private void actionUpKey() {
        this.setFocusIndex(this.focusIndex - 1, true);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof EclTableColumn) {
            this.myColumnList.add((Object)component);
            if (this.eclModel != null) {
                this.eclModel.initialiseColumn((EclTableColumn)component);
            }
        }
    }

    public void addRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this.aRowSelectionListener = RowSelectionEventMulticaster.add(this.aRowSelectionListener, rowSelectionListener);
    }

    void calculateMaxIndex() {
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(0);
            this.maxIndex = eclTableColumn.getColumnBodyComponentCount() - 1;
            int n = 1;
            while (n < this.myColumnList.size()) {
                eclTableColumn = (EclTableColumn)this.myColumnList.get(n);
                int n2 = eclTableColumn.getColumnBodyComponentCount();
                this.maxIndex = n2 - 1 < this.maxIndex ? n2 - 1 : this.maxIndex;
                ++n;
            }
        }
        if (this.focusIndex > this.maxIndex) {
            this.setFocusIndex(-1);
        }
        if (this.selectedIndex > this.maxIndex) {
            this.setSelectedIndex(-1);
        }
    }

    protected ApplicationGenericMetaData createMetaData(int n) {
        ApplicationGenericMetaData applicationGenericMetaData = null;
        try {
            if (this.theParamList != null) {
                applicationGenericMetaData = new ApplicationGenericMetaData();
                PrimitiveTypesWriter primitiveTypesWriter = applicationGenericMetaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(n);
                primitiveTypesWriter.write(this.startIndex);
                primitiveTypesWriter.write(this.getEclModel().getNumRows());
                primitiveTypesWriter.write(this.theParamList.size());
                int n2 = 0;
                while (n2 < this.theParamList.size()) {
                    primitiveTypesWriter.write(this.theParamList.get(n2).toString());
                    ++n2;
                }
                applicationGenericMetaData.completedMetaDataInitialisation();
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Data Names were NOT passed in from the columns - cannot create meta data! Check that the data name field has been specified for each column at design-time.");
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Creation of meta data failed!");
        }
        return applicationGenericMetaData;
    }

    public void finishInitialise() {
        if (this.eclModel != null) {
            this.trapTransientError(true);
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < this.getComponentCount()) {
                if (componentArray[n] instanceof CcComponent) {
                    ((CcComponent)((Object)componentArray[n])).finishInitialise();
                }
                ++n;
            }
            EclTableColumn eclTableColumn = null;
            String string = null;
            int n2 = 0;
            while (n2 < this.myColumnList.size()) {
                eclTableColumn = (EclTableColumn)this.myColumnList.get(n2);
                string = eclTableColumn.getDataName();
                if (string != null) {
                    this.theParamList.add((Object)string);
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: column " + eclTableColumn.toString() + " does not define a data name! The table will be unusable.");
                    this.permanentError();
                }
                ++n2;
            }
            this.getEclModel().finishInitialise();
            if (this.isFocusTraversable()) {
                this.navigationMode = 0;
            }
            this.validate();
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: A model is required to initialise its columns.");
            this.permanentError();
        }
    }

    protected void fireSelectRow(RowSelectionEvent rowSelectionEvent) {
        if (this.aRowSelectionListener == null) {
            return;
        }
        this.aRowSelectionListener.selectRow(rowSelectionEvent);
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclTableDefaults.transientErrorColour : super.getBackground();
    }

    private ContextHelpController getContextHelpController() {
        if (this.contextHelpController == null) {
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof ContextHelpController) {
                    this.contextHelpController = (ContextHelpController)((Object)container);
                    break;
                }
                container = container.getParent();
            }
        }
        return this.contextHelpController;
    }

    public String getDomainName() {
        return this.DomainName;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.getEclTableView();
    }

    public EclTableModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclTableModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
            this.updateColumns();
        }
        return this.eclModel;
    }

    public EclTableView getEclTableView() {
        return this.eclView;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getForeground() {
        return this.myForegroundColor;
    }

    /*
     * Unable to fully structure code
     */
    UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclTable.theMainKeyController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclTable.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclTable.theMainKeyController;
    }

    public void getNextLine() {
        if (!this.endOfDataReached) {
            ++this.startIndex;
            this.query(5);
        }
    }

    public void getNextPage() {
        if (!this.endOfDataReached) {
            this.startIndex += this.getEclModel().getNumRows();
            this.query(3);
        }
    }

    public void getPrevLine() {
        if (this.startIndex > 0) {
            --this.startIndex;
            this.query(6);
        }
    }

    public void getPrevPage() {
        if (this.startIndex > 0) {
            this.startIndex -= this.getEclModel().getNumRows();
            if (this.startIndex < 0) {
                this.startIndex = 0;
            }
            this.query(4);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        EclTableModel eclTableModel = this.getEclModel();
        if (this.getEclTableView() == null) {
            eclTableModel.createView();
        }
    }

    private void initialize() {
        this.enableEvents(12L);
        this.setSize(200, 100);
        this.setLayout(new TableLayout());
        this.myColumnList = new ArrayList();
        this.theParamList = new ArrayList();
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
    }

    public boolean isFocusTraversable() {
        return this.getEclModel().isFocusable();
    }

    void permanentError() {
        this.trapTransientError(false);
        this.hasTrappedPermanentError = true;
        this.setBackground(EclTableDefaults.permanentErrorColour);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        switch (n) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                this.getContextHelpController().displayContextHelp("TableHelpId");
                break;
            }
            case 1005: {
                this.hasFocus = false;
                this.getContextHelpController().removeContextHelp("TableHelpId");
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            if (this.navigationMode == 1) {
                switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                    case 10: {
                        this.getContextHelpController().displayContextHelp("TableHelpId");
                        this.navigationMode = 0;
                        this.setSelectedIndex();
                        this.fireSelectRow(new RowSelectionEvent(this));
                        this.setFocusIndex(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 27: {
                        this.getContextHelpController().displayContextHelp("TableHelpId");
                        this.navigationMode = 0;
                        this.setFocusIndex(-1);
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        this.actionDownKey();
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        this.actionUpKey();
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        keyEvent.consume();
                        break;
                    }
                }
            } else if (this.navigationMode == 0) {
                switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                    case 10: {
                        if (this.maxIndex > -1) {
                            this.navigationMode = 1;
                            this.setFocusIndex(0);
                            this.getContextHelpController().displayContextHelp("RowHelpId");
                        }
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this);
                        break;
                    }
                }
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": processKeyEvent: Unknown navigation mode");
            }
        }
    }

    private int processReceivedData(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        int n = 0;
        try {
            this.setEndOfDataReached(primitiveTypesReader.readBoolean());
            n = primitiveTypesReader.readInt();
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < this.myColumnList.size()) {
                EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(n2);
                String string = primitiveTypesReader.readString();
                if (!string.equals(eclTableColumn.getDataName())) {
                    throw new IOException("Invalid dataName received or dataName in wrong order");
                }
                boolean bl = primitiveTypesReader.readBoolean();
                if (bl) {
                    arrayList.clear();
                    int n3 = 0;
                    while (n3 < n) {
                        arrayList.add(n3, (Object)new Float(primitiveTypesReader.readFloat()));
                        ++n3;
                    }
                    eclTableColumn.setContents(arrayList);
                }
                ++n2;
            }
            this.trapTransientError(false);
        }
        catch (IOException iOException) {
            EventLog.instance().log(iOException.toString());
            EventLog.instance().log("ERROR: " + this.toString() + ": processReceivedData: Received meaningless data");
            throw iOException;
        }
        return n;
    }

    public void query(int n) {
        ApplicationGenericMetaData applicationGenericMetaData = this.createMetaData(n);
        if (applicationGenericMetaData != null) {
            this.theApplicationObject.asyncQuery(applicationGenericMetaData, this);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": query: Unable to create meta data! Query for AO " + this.theApplicationObject.toString() + " failed.");
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData applicationGenericData, ApplicationDataSender applicationDataSender) {
        PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
        if (primitiveTypesReader == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Unable to get primitive reader");
            this.trapTransientError(true);
        } else if (applicationDataSender == this.theApplicationObject) {
            try {
                int n = primitiveTypesReader.readInt();
                switch (n) {
                    case -1: {
                        this.startIndex = 0;
                        this.setFocusIndex(-1);
                        this.setSelectedIndex(-1);
                        this.query(1);
                        break;
                    }
                    case 0: {
                        if (this.endOfDataReached) {
                            this.query(2);
                        }
                        break;
                    }
                    case -2: {
                        this.query(2);
                        break;
                    }
                    case 5: {
                        int n2 = this.processReceivedData(primitiveTypesReader);
                        if (this.navigationMode == 1) {
                            this.setFocusIndex(n2 - 1);
                        } else {
                            this.setFocusIndex(-1);
                        }
                        this.setSelectedIndex(this.selectedIndex);
                        if (this.scroller != null) {
                            this.scroller.atStartOfData(this.startIndex <= 0);
                        }
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: {
                        this.processReceivedData(primitiveTypesReader);
                        if (this.navigationMode == 1) {
                            this.setFocusIndex(0);
                        } else {
                            this.setFocusIndex(-1);
                        }
                        this.setSelectedIndex(this.selectedIndex);
                        if (this.scroller != null) {
                            this.scroller.atStartOfData(this.startIndex <= 0);
                        }
                        break;
                    }
                    case 2: {
                        this.processReceivedData(primitiveTypesReader);
                        if (this.navigationMode == 1) {
                            this.setFocusIndex(this.focusIndex);
                        } else {
                            this.setFocusIndex(-1);
                        }
                        this.setSelectedIndex(this.selectedIndex);
                        if (this.scroller != null) {
                            this.scroller.atStartOfData(this.startIndex <= 0);
                        }
                        break;
                    }
                    default: {
                        EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: unknown data ID: " + n);
                    }
                }
            }
            catch (IOException iOException) {
                EventLog.instance().log(iOException.toString());
                EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received meaningless data");
                this.trapTransientError(true);
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Unhandled data received from " + applicationDataSender.toString());
        }
    }

    public void removeNotify() {
        this.hasFocus = false;
        super.removeNotify();
    }

    public void removeRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this.aRowSelectionListener = RowSelectionEventMulticaster.remove(this.aRowSelectionListener, rowSelectionListener);
    }

    public void setDomainName(String string) {
        this.DomainName = string;
    }

    public void setEclModel(EclTableModel eclTableModel) {
        this.eclModel = eclTableModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
            this.updateColumns();
        }
    }

    public void setEclTableView(EclTableView eclTableView) {
        this.eclView = eclTableView;
    }

    public void setEndOfDataReached(boolean bl) {
        if (this.endOfDataReached != bl) {
            this.endOfDataReached = bl;
            if (this.scroller != null) {
                this.scroller.atEndOfData(bl);
            }
        }
    }

    public void setFocusIndex(int n) {
        this.setFocusIndex(n, false);
    }

    public void setFocusIndex(int n, boolean bl) {
        if (bl) {
            if (n < 0) {
                this.getPrevLine();
                return;
            }
            if (n > this.maxIndex) {
                this.getNextLine();
                return;
            }
        }
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            this.focusIndex = n;
            int n2 = 0;
            while (n2 < this.myColumnList.size()) {
                EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(n2);
                eclTableColumn.setFocusIndex(this.focusIndex);
                ++n2;
            }
        }
    }

    public void setFont(Font font) {
        this.myFont = font;
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setForeground(Color color) {
        this.myForegroundColor = color;
        super.setForeground(color);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setScroller(Scroller scroller) {
        this.scroller = scroller;
        this.scroller.atEndOfData(this.endOfDataReached);
    }

    public void setSelectedIndex() {
        this.setSelectedIndex(this.startIndex + this.focusIndex);
    }

    public void setSelectedIndex(int n) {
        if (n < -1) {
            return;
        }
        if (this.myColumnList != null && this.myColumnList.size() > 0) {
            int n2 = -1;
            if (n >= this.startIndex && n < this.startIndex + this.getEclModel().getNumRows()) {
                n2 = n - this.startIndex;
            }
            int n3 = 0;
            while (n3 < this.myColumnList.size()) {
                EclTableColumn eclTableColumn = (EclTableColumn)this.myColumnList.get(n3);
                eclTableColumn.setSelectedIndex(n2);
                ++n3;
            }
        }
        this.selectedIndex = n;
    }

    public String toString() {
        String string = this.getName();
        return string == null || string.length() == 0 ? "EclTable" : string;
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        if (applicationData != null) {
            try {
                applicationData.receivedBy(this, applicationObject);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update: Don't have the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
                this.unregister();
            }
        } else if (applicationObject == this.theApplicationObject) {
            this.query(1);
        }
    }

    void updateColumns() {
        int n = 0;
        while (n < this.myColumnList.size()) {
            this.getEclModel().initialiseColumn((EclTableColumn)this.myColumnList.get(n));
            ++n;
        }
    }
}

