/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table2;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.ColumnLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableColumnModel;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableColumnView;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.Beans;

public class EclTableColumn
extends EclipseContainer
implements CcComponent {
    private EclTableColumnModel eclModel = null;
    private transient EclTableColumnView eclView = null;
    private transient boolean hasTrappedTransientError = false;

    public EclTableColumn() {
        this.initialize();
    }

    public void finishInitialise() {
        this.getEclModel().finishInitialise();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).finishInitialise();
            }
            ++n;
        }
        this.validate();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclTableDefaults.transientErrorColour : super.getBackground();
    }

    public int getColumnBodyComponentCount() {
        return this.getEclTableColumnView().getColumnBodyComponentCount();
    }

    public String getDataName() {
        return this.getEclModel().getDataName();
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.getEclTableColumnView();
    }

    public EclTableColumnModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclTableColumnModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public EclTableColumnView getEclTableColumnView() {
        return this.eclView;
    }

    protected void initialiseModel() {
        EclTableColumnModel eclTableColumnModel = this.getEclModel();
        if (this.getEclTableColumnView() == null) {
            eclTableColumnModel.createView();
        }
    }

    private void initialize() {
        this.setLayout(new ColumnLayout());
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
    }

    public void initialize(Color color, Color color2, Font font, boolean bl, Color color3, boolean bl2, int n) {
        this.setForeground(color);
        this.setBackground(color2);
        this.setFont(font);
        if (this.getEclTableColumnView() != null) {
            this.getEclTableColumnView().initialise(bl, color3, bl2, n);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": initialize: requires an initialised model.");
            this.permanentError();
        }
    }

    void permanentError() {
        this.setBackground(EclTableDefaults.permanentErrorColour);
        this.trapTransientError(false);
        this.getEclModel().createView();
        this.setVisible(true);
    }

    public void setContents(ArrayList arrayList) {
        this.getEclTableColumnView().populateBody(arrayList.iterator());
        this.trapTransientError(false);
    }

    public void setEclModel(EclTableColumnModel eclTableColumnModel) {
        this.eclModel = eclTableColumnModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclTableColumnView(EclTableColumnView eclTableColumnView) {
        this.eclView = eclTableColumnView;
    }

    void setFocusIndex(int n) {
        this.getEclTableColumnView().setFocusIndex(n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    void setSelectedIndex(int n) {
        this.getEclTableColumnView().setSelectedIndex(n);
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclTableColumn" : string;
        return String.valueOf(string2) + ": " + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
        }
    }

    public void unregister() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
    }
}

