/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table2;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.table2.AccessibleEclTableModel;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTable;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table2.EclTableView;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclTableModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 8875919383368498292L;
    private String dbVariable;
    private String dbGreyVariable;
    private int numRows;
    private Color lineColor;
    private boolean focusable;
    private boolean drawLines;
    private boolean drawHeaders;
    private boolean drawBorder;
    private transient EclTable controller;

    public EclTableModel() {
        this(null, null, EclTableDefaults.foreground, 8, true, true, true, false);
    }

    public EclTableModel(String string, String string2, Color color, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.dbVariable = string;
        this.dbGreyVariable = string2;
        this.numRows = n;
        this.lineColor = color;
        this.drawLines = bl;
        this.drawHeaders = bl2;
        this.drawBorder = bl3;
        this.focusable = bl4;
    }

    AccessibleEclTableModel createAccessibleModel() {
        return new AccessibleEclTableModel(this.dbVariable, this.dbGreyVariable, this.lineColor, this.numRows, this.drawLines, this.drawHeaders, this.drawBorder, this.focusable, this.controller);
    }

    public void createView() {
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclTableDefaults.background);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclTableDefaults.foreground);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclTableDefaults.font);
        }
        if (this.controller.getEclTableView() == null) {
            this.controller.setEclTableView(new EclTableView(this.controller));
        }
    }

    public void finishInitialise() {
        if (this.dbVariable != null) {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.dbVariable, (ApplicationObjectObserver)this.controller, null);
        } else {
            EventLog.instance().log("INFO: " + this.controller.toString() + ": finishInitialise: No database variable specified.");
            this.controller.permanentError();
        }
        if (this.dbGreyVariable != null) {
            EventLog.instance().log("INFO: " + this.controller.toString() + ": finishInitialise: Grey variable not supported.");
            this.controller.permanentError();
        }
    }

    String getDataVariableName() {
        return this.dbVariable;
    }

    boolean getDrawBorder() {
        return this.drawBorder;
    }

    boolean getDrawLines() {
        return this.drawLines;
    }

    String getGreyVariableName() {
        return this.dbGreyVariable;
    }

    Color getLineColor() {
        return this.lineColor;
    }

    int getNumRows() {
        return this.numRows;
    }

    public void initialiseColumn(EclTableColumn eclTableColumn) {
        eclTableColumn.initialize(this.controller.getForeground(), this.controller.getBackground(), this.controller.getFont(), this.drawHeaders, this.lineColor, this.drawLines, this.numRows);
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclTableDefaults.font);
        this.controller.setForeground(EclTableDefaults.foreground);
        this.controller.setBackground(EclTableDefaults.background);
    }

    boolean isFocusable() {
        return this.focusable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.dbVariable = (String)objectInputStream.readObject();
                this.dbGreyVariable = (String)objectInputStream.readObject();
                this.lineColor = (Color)objectInputStream.readObject();
                this.numRows = objectInputStream.readInt();
                this.drawLines = objectInputStream.readBoolean();
                this.drawHeaders = objectInputStream.readBoolean();
                this.drawBorder = objectInputStream.readBoolean();
                this.focusable = objectInputStream.readBoolean();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclTableModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclTable eclTable) {
        this.controller = eclTable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.dbVariable);
        objectOutputStream.writeObject(this.dbGreyVariable);
        objectOutputStream.writeObject(this.lineColor);
        objectOutputStream.writeInt(this.numRows);
        objectOutputStream.writeBoolean(this.drawLines);
        objectOutputStream.writeBoolean(this.drawHeaders);
        objectOutputStream.writeBoolean(this.drawBorder);
        objectOutputStream.writeBoolean(this.focusable);
    }
}

