/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.table2;

import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTableDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelView;
import com.agilent.tntd.eclipse.viewlayer.components.table2.TableColumnComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TableColumnLabel
extends EclLabel
implements TableColumnComponent {
    private transient boolean selected;
    private transient boolean hasFocus;

    public Color getBackground() {
        return this.isSelected() ? EclTableDefaults.selectedBackground : super.getBackground();
    }

    public Font getFont() {
        Font font = super.getFont();
        return this.isSelected() ? new Font(font.getName(), 1, font.getSize()) : font;
    }

    public Color getForeground() {
        return this.isSelected() ? EclTableDefaults.selectedForeground : super.getForeground();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(((EclLabelView)this.getEclipseView()).getTextProperty());
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        return new Dimension(n += 4, n2);
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.hasFocus()) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(EclTableDefaults.focusColor);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        }
    }

    public void setFocus(boolean bl) {
        this.hasFocus = bl;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }
}

