/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.togglebutton;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclToggleButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.BooleanState;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseButtonHandler;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedEvent;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedEventMulticaster;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedListener;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButtonView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;

public class EclToggleButton
extends EclipseComponent
implements CcGreyableComponent {
    private EclToggleButtonModel eclModel;
    private transient EclToggleButtonView eclView;
    protected transient ActionPerformedListener aActionPerformedListener = null;
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient boolean hasFocus = false;
    private transient boolean hasTrappedTransientError = false;
    private transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient String greyDomainName = "ISS";
    protected static transient MouseButtonHandler theMouseButtonHandler = null;
    private transient BooleanState isActionning = null;

    public EclToggleButton() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.enableEvents(12L);
        this.createMouseButtonHandler();
        this.setSize(70, 20);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            if (this.eclModel.getPropertyIDForName(string) == 10) {
                this.theApplicationObject = applicationObject;
            } else {
                this.theGreyApplicationObject = applicationObject;
            }
        }
    }

    void action() {
        if (this.theApplicationObject != null) {
            MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(1);
            this.theApplicationObject.change(maskedIntegerValue);
        }
        this.fireActionPerformed(new ActionPerformedEvent(this));
    }

    public void addActionPerformedListener(ActionPerformedListener actionPerformedListener) {
        this.aActionPerformedListener = ActionPerformedEventMulticaster.add(this.aActionPerformedListener, actionPerformedListener);
    }

    protected void createMouseButtonHandler() {
        if (theMouseButtonHandler == null) {
            theMouseButtonHandler = new MouseButtonHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.getEclModel().finishInitialise();
    }

    protected void fireActionPerformed(ActionPerformedEvent actionPerformedEvent) {
        if (this.aActionPerformedListener != null) {
            this.aActionPerformedListener.actionPerformed(actionPerformedEvent);
        }
    }

    protected BooleanState getActionningState() {
        if (this.isActionning == null) {
            this.isActionning = new BooleanState(false);
        }
        return this.isActionning;
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclToggleButtonDefaults.transientErrorColour : super.getBackground();
    }

    protected EclipseView getEclipseView() {
        return this.getEclToggleButtonView();
    }

    public EclToggleButtonModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclToggleButtonModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    EclToggleButtonView getEclToggleButtonView() {
        return this.eclView;
    }

    public String getGreyDomainName() {
        return this.greyDomainName;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = new Dimension(10 + Math.max(70, fontMetrics.stringWidth(this.getEclModel().getText())), 4 + Math.max(20, fontMetrics.getHeight()));
        return dimension;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    void permanentError() {
        this.setBackground(EclToggleButtonDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        switch (n) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    this.eclView.loseFocus();
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
                this.eclView.loseFocus();
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclToggleButtonView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseButtonHandler.processMouseEvent(mouseEvent, this.eclView, this.getActionningState(), this.hasFocus, this.isEnabled());
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                this.thePreviousIndexValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedSelectionState(this.thePreviousIndexValue));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void removeActionPerformedListener(ActionPerformedListener actionPerformedListener) {
        this.aActionPerformedListener = ActionPerformedEventMulticaster.remove(this.aActionPerformedListener, actionPerformedListener);
    }

    public void setEclModel(EclToggleButtonModel eclToggleButtonModel) {
        this.eclModel = eclToggleButtonModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclToggleButtonView(EclToggleButtonView eclToggleButtonView) {
        this.eclView = eclToggleButtonView;
    }

    public void setGreyDomainName(String string) {
        this.greyDomainName = string;
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void setValue(boolean bl) {
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(bl ? 1 : 0);
        if (!this.theApplicationObject.change(maskedIntegerValue)) {
            EclipseSystem.instance().beep();
            System.out.println(String.valueOf(this.toString()) + "  requested change failed.");
            this.getEclModel().updatedSelectionState(this.thePreviousIndexValue);
        }
    }

    private void testForValidity() {
        if (this.getEclModel().updatedSelectionState(this.thePreviousIndexValue) && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclToggleButton" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousIndexValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

