/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.togglebutton;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclToggleButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.AccessibleEclToggleButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButtonView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclToggleButtonModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -4493351661867646849L;
    private String helpId = null;
    private String databaseVariable;
    private String databaseGreyVariable;
    private String text;
    private boolean latching;
    private transient EclToggleButton controller;

    public EclToggleButtonModel() {
        this.databaseVariable = null;
        this.databaseGreyVariable = null;
        this.text = "Text";
        this.latching = true;
    }

    public EclToggleButtonModel(String string, String string2, String string3, boolean bl) {
        this.text = string;
        this.databaseVariable = string2;
        this.databaseGreyVariable = string3;
        this.latching = bl;
    }

    public EclToggleButtonModel(String string, String string2, String string3, boolean bl, String string4) {
        this.text = string;
        this.databaseVariable = string2;
        this.databaseGreyVariable = string3;
        this.latching = bl;
        this.helpId = string4;
    }

    protected AccessibleEclToggleButtonModel createAccessibleModel() {
        return new AccessibleEclToggleButtonModel(this.text, this.databaseVariable, this.databaseGreyVariable, this.latching, this.helpId, this.getController());
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclToggleButtonDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclToggleButtonDefaults.font);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclToggleButtonDefaults.foreground);
        }
        if (this.getController().getEclToggleButtonView() == null) {
            this.getController().setEclToggleButtonView(new EclToggleButtonView(this.getController()));
        }
        this.getController().getEclToggleButtonView().setText(this.text);
        this.getController().getEclToggleButtonView().setLatching(this.latching);
    }

    public void finishInitialise() {
        if (this.databaseVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseVariable, (ApplicationObjectObserver)this.getController());
        }
        if (this.databaseGreyVariable != null) {
            ApplicationManager.instance().request(this.getController().getGreyDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.getController());
        }
    }

    private EclToggleButton getController() {
        return this.controller;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public String getText() {
        return this.text;
    }

    public void initialiseDefaults() {
        this.getController().setFont(EclToggleButtonDefaults.font);
        this.getController().setForeground(EclToggleButtonDefaults.foreground);
        this.getController().setBackground(EclToggleButtonDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.latching = objectInputStream.readBoolean();
                break;
            }
            case 1: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.latching = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                break;
            }
            default: {
                System.out.println("Attempted to deserialise an unknown version of EclToggleButtonModel: " + n);
            }
        }
    }

    public void setController(EclToggleButton eclToggleButton) {
        this.controller = eclToggleButton;
    }

    public String toString() {
        return "[" + (this.databaseVariable == null ? "null" : this.databaseVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    public boolean updatedSelectionState(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().getEclToggleButtonView().setValue(maskedIntegerValue.getValue() == 1);
            }
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.text);
        objectOutputStream.writeObject(this.databaseVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeBoolean(this.latching);
        objectOutputStream.writeObject(this.helpId);
    }
}

