/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.togglebutton;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseGraphicsHelper;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclToggleButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseButton;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public class EclToggleButtonView
implements EclipseView,
MouseButton {
    private EclToggleButton controller;
    private String text = "";
    private Point textOrigin = new Point(0, 0);
    private Color highlight = null;
    private Color shadow = null;
    private boolean latching = true;
    private boolean value = false;
    private boolean raised = true;
    private boolean firstDone = false;
    private static UnconsumedKeyHandler theMainKeyController = null;

    public EclToggleButtonView(EclToggleButton eclToggleButton) {
        this.controller = eclToggleButton;
        if (this.controller != null) {
            this.calculateGeometry();
        }
    }

    private void calculateGeometry() {
        FontMetrics fontMetrics = this.controller.getFontMetrics(this.controller.getFont());
        int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.textOrigin.x = (this.controller.getBounds().width - fontMetrics.stringWidth(this.text)) / 2;
        this.textOrigin.y = (this.controller.getBounds().height - n) / 2 + fontMetrics.getMaxAscent();
    }

    private void derive3DColours() {
        Color color = this.controller.getVisibleBackground();
        this.highlight = color.brighter();
        this.shadow = color.darker();
    }

    public void doLeftClickAction() {
        if (!this.raised) {
            this.raised = true;
            this.controller.repaint();
            this.controller.action();
        }
    }

    public void doRightClickAction() {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.controller), this.controller);
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclToggleButtonView.theMainKeyController != null) break block2;
            var1_1 = this.controller.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.controller.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclToggleButtonView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclToggleButtonView.theMainKeyController;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean isSunken() {
        return !this.raised;
    }

    void loseFocus() {
        if (!this.raised) {
            this.raised = true;
        }
    }

    public void notifyEclipseComponentChanged() {
        this.calculateGeometry();
    }

    public void paint(Graphics graphics) {
        Color color = this.controller.getBackground();
        this.controller.getForeground();
        if (Beans.isDesignTime() || this.highlight == null) {
            this.derive3DColours();
        }
        int n = this.controller.getBounds().width;
        int n2 = this.controller.getBounds().height;
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        }
        graphics.setFont(this.controller.getFont());
        graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.shadow);
        graphics.drawString(this.text, this.textOrigin.x, this.textOrigin.y);
        if (this.raised) {
            EclipseGraphicsHelper.paintRaisedBox(graphics, 1, 1, n - 2, n2 - 2);
        } else {
            EclipseGraphicsHelper.paintSunkenBox(graphics, 1, 1, n - 2, n2 - 2);
        }
        if (Beans.isDesignTime()) {
            graphics.setColor(this.shadow);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
        if (this.controller.hasFocus()) {
            graphics.setColor(EclToggleButtonDefaults.focusColour);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    private void paint3DHighlights(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = 0;
        while (n8 < n5) {
            graphics.setColor(bl ? color : color2);
            graphics.drawLine(n + n8, n2 + n8, n6 - n8, n2 + n8);
            graphics.drawLine(n + n8, n2 + n8, n + n8, n7 - n8);
            graphics.setColor(bl ? color2 : color);
            graphics.drawLine(n6 - n8, n2 + n8, n6 - n8, n7 - n8);
            graphics.drawLine(n + n8, n7 - n8, n6 - n8, n7 - n8);
            ++n8;
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (InstrumentKeyMappings.deriveKeyType(keyEvent) == 10) {
            if (keyEvent.getID() == 401) {
                this.raised = false;
                this.controller.repaint();
                keyEvent.consume();
            }
            if (keyEvent.getID() == 402) {
                if (!this.raised) {
                    this.raised = true;
                    this.controller.repaint();
                    this.controller.action();
                }
                keyEvent.consume();
            }
        }
        if (InstrumentKeyMappings.deriveKeyType(keyEvent) == 27 && !this.raised && keyEvent.getID() == 401) {
            this.raised = true;
            this.controller.repaint();
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.controller);
        }
    }

    public void repaint() {
        this.controller.repaint();
    }

    public void requestFocus() {
        this.controller.requestFocus();
    }

    public void setLatching(boolean bl) {
        this.latching = bl;
    }

    public void setSunken(boolean bl) {
        this.raised = !bl;
    }

    public void setText(String string) {
        this.text = string;
        this.calculateGeometry();
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }
}

