/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.dialog;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import java.awt.Component;
import java.awt.event.KeyEvent;

public class EclDialogKeyConsumer
implements UnconsumedKeyHandler {
    private EclDialog myWindow;
    private DialogEventReceiver myReceiver;

    public EclDialogKeyConsumer(EclDialog eclDialog, DialogEventReceiver dialogEventReceiver) {
        this.myWindow = eclDialog;
        this.myReceiver = dialogEventReceiver;
        if (this.myWindow == null || this.myReceiver == null) {
            throw new NullPointerException("EclDialogKeyConsumer cannot have a null window or DialogEventReceiver");
        }
    }

    public void processUnconsumedKeyEvents(KeyEvent keyEvent, Component component) {
        switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
            case 107: 
            case 113: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                EclipseSystem.instance().beep();
                keyEvent.consume();
                break;
            }
            case 27: {
                if (keyEvent.getID() == 401) {
                    this.myReceiver.notifyEvent(1, this.myWindow);
                }
                keyEvent.consume();
            }
        }
    }
}

