/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.pane;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.PanePageContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclPaneDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPaneModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.Beans;

public class EclPane
extends EclipseContainer
implements CcConnectedComponent,
MaskedIntegerDataReceiver,
CompositeDataReceiver,
IndexPropertyAccessor {
    private EclPaneModel eclModel;
    protected transient ApplicationObject theApplicationObject = null;
    protected transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient PanePageContainer panePageContainer = null;
    protected transient boolean hasTrappedTransientError = false;
    private transient String DomainName = "ISS";
    private transient boolean isInitialChange;

    public EclPane() {
        this.initialise();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.isInitialChange = true;
            this.theApplicationObject = applicationObject;
        }
    }

    protected EclPaneModel createDefaultModel() {
        EclPaneModel eclPaneModel = new EclPaneModel();
        return eclPaneModel;
    }

    public void finishInitialise() {
        if (this.initialisePanePageContainer(this) == null) {
            EventLog.instance().log(String.valueOf(this.toString()) + " is not a child (direct or indirect) of a PanePageContainer.");
            this.permanentError();
        } else {
            this.trapTransientError(true);
            this.getEclModel().finishInitialise();
        }
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclPaneDefaults.transientErrorColour : super.getBackground();
    }

    public String getDomainName() {
        return this.DomainName;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return null;
    }

    public EclPaneModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = this.createDefaultModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    protected boolean hasView() {
        return false;
    }

    protected void initialise() {
        this.setSize(200, 100);
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel().initialiseDefaults();
        }
    }

    private PanePageContainer initialisePanePageContainer(Component component) {
        this.panePageContainer = null;
        while (component != null) {
            if (component instanceof PanePageContainer) {
                this.panePageContainer = (PanePageContainer)((Object)component);
                break;
            }
            component = component.getParent();
        }
        return this.panePageContainer;
    }

    public void paint(Graphics graphics) {
        if (!this.hasView()) {
            if (this.getBackground() != null) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            }
            if (Beans.isDesignTime()) {
                graphics.setColor(this.getVisibleBackground().darker());
                graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            }
        }
        super.paint(graphics);
    }

    protected void permanentError() {
        this.unregister();
        this.hasTrappedTransientError = false;
        this.setBackground(EclPaneDefaults.permanentErrorColour);
        this.repaint();
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            this.trapTransientError(!compositeData.update(this.getEclModel().getCompositeDataID(), this, this.isInitialChange));
            this.isInitialChange = false;
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue) || this.hasTrappedTransientError) {
                this.selectPanePage(maskedIntegerValue.getValue());
                this.thePreviousIndexValue = maskedIntegerValue;
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    private void selectPanePage(int n) {
        try {
            if (this.thePreviousIndexValue == null || this.hasTrappedTransientError || !this.getEclModel().getPanePageNameAt(this.thePreviousIndexValue.getValue()).equals(this.getEclModel().getPanePageNameAt(n))) {
                Component component = null;
                component = this.panePageContainer.activateMethod("get" + this.getEclModel().getPanePageNameAt(n));
                if (component != null) {
                    if (component.getParent() != null) {
                        this.trapTransientError(true);
                        EventLog.instance().log(String.valueOf(this.toString()) + " cannot use " + component.toString() + " because it is already the child of " + component.getParent().toString());
                        if (this.getComponentCount() != 0) {
                            this.getComponent(0).setVisible(false);
                            if (this.getComponent(0) instanceof CcComponent) {
                                ((CcComponent)((Object)this.getComponent(0))).unregister();
                            }
                            this.remove(this.getComponent(0));
                        }
                    } else {
                        Insets insets = this.getInsets();
                        component.setLocation(insets.left, insets.top);
                        component.setVisible(false);
                        this.add(component, component.getName());
                        if (component instanceof CcComponent) {
                            ((CcComponent)((Object)component)).finishInitialise();
                        }
                        component.setVisible(true);
                        this.trapTransientError(false);
                        if (this.getComponentCount() == 2) {
                            this.getComponent(0).setVisible(false);
                            if (this.getComponent(0) instanceof CcComponent) {
                                ((CcComponent)((Object)this.getComponent(0))).unregister();
                            }
                            this.remove(this.getComponent(0));
                        } else if (this.getComponentCount() > 1) {
                            this.trapTransientError(true);
                            EventLog.instance().log("Error more than one panepage in " + this.toString() + " called " + this.getName());
                        }
                    }
                    this.validate();
                } else {
                    this.trapTransientError(true);
                    EventLog.instance().log("Error: Cannot activate pane page indexed at " + n + " in " + this.toString() + " called " + this.getEclModel().getPanePageNameAt(n));
                    EventLog.instance().log("Either it doesn't exist or you forgot to add the code for the Reflection API");
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.trapTransientError(true);
            EventLog.instance().log("Error: There is no pane page number " + n + " in " + this.toString());
        }
    }

    public void setDomainName(String string) {
        this.DomainName = string;
    }

    public void setEclModel(EclPaneModel eclPaneModel) {
        this.eclModel = eclPaneModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public boolean setIndexProperty(int n) {
        if (this.thePreviousIndexValue == null || this.thePreviousIndexValue.getValue() != n || this.hasTrappedTransientError) {
            this.selectPanePage(n);
            this.thePreviousIndexValue = new MaskedIntegerValue(n);
        }
        return !this.hasTrappedTransientError;
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclPane" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            if (bl) {
                if (this.getComponentCount() != 0) {
                    this.getComponent(0).setVisible(false);
                    if (this.getComponent(0) instanceof CcComponent) {
                        ((CcComponent)((Object)this.getComponent(0))).unregister();
                    }
                    this.remove(this.getComponent(0));
                }
                if (this.getComponentCount() != 0) {
                    EventLog.instance().log("Error more than one panepage in " + this.toString() + " called " + this.getName());
                }
                this.validate();
            }
            this.repaint();
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousIndexValue = null;
        }
        if (this.getComponentCount() != 0) {
            Component component = this.getComponent(0);
            if (component instanceof CcComponent) {
                ((CcComponent)((Object)component)).unregister();
            }
            this.remove(0);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

