/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.pane;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclPaneDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.AccessibleEclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPane;
import java.awt.CardLayout;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclPaneModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -259127573204065598L;
    private transient EclPane theController;
    private String databaseVariableName;
    private String[] panepageNames;
    private int compositeDataId;

    public EclPaneModel() {
        this.databaseVariableName = null;
        this.panepageNames = null;
        this.compositeDataId = -1;
    }

    protected EclPaneModel(EclPaneModel eclPaneModel) {
        this.databaseVariableName = eclPaneModel.databaseVariableName;
        this.panepageNames = eclPaneModel.panepageNames;
        this.compositeDataId = eclPaneModel.compositeDataId;
    }

    public EclPaneModel(String string, String[] stringArray) {
        this.databaseVariableName = string;
        this.panepageNames = stringArray;
        this.compositeDataId = -1;
    }

    public EclPaneModel(String string, String[] stringArray, int n) {
        this.databaseVariableName = string;
        this.panepageNames = stringArray;
        this.compositeDataId = n;
    }

    protected AccessibleEclPaneModel createAccessibleModel() {
        return new AccessibleEclPaneModel(this.databaseVariableName, this.panepageNames, this.compositeDataId, this.getController());
    }

    public void createView() {
        if (Beans.isDesignTime()) {
            this.getController().setLayout(new CardLayout());
        }
    }

    public void finishInitialise() {
        if (this.databaseVariableName == null) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " requires a variable name");
            this.getController().permanentError();
        } else if (this.panepageNames == null) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " requires a at least one item in its list of pane page names.");
            this.getController().permanentError();
        } else {
            ApplicationManager.instance().request(this.getController().getDomainName(), 1, this.databaseVariableName, (ApplicationObjectObserver)this.getController());
        }
    }

    public int getCompositeDataID() {
        return this.compositeDataId;
    }

    protected EclPane getController() {
        return this.theController;
    }

    public String getPanePageNameAt(int n) {
        return this.panepageNames[n];
    }

    public void initialiseDefaults() {
        this.getController().setBackground(EclPaneDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                objectInputStream.readInt();
                this.panepageNames = (String[])objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 1: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.panepageNames = (String[])objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 2: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.panepageNames = (String[])objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclPaneModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclPane eclPane) {
        this.theController = eclPane;
    }

    public String toString() {
        return "[" + (this.databaseVariableName == null ? "null" : this.databaseVariableName) + (this.compositeDataId == -1 ? "" : ", " + this.compositeDataId) + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(this.databaseVariableName);
        objectOutputStream.writeObject(this.panepageNames);
        objectOutputStream.writeInt(this.compositeDataId);
    }
}

