/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.panepage;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.Beans;

public class EclPanePageView
implements EclipseContainerView {
    private transient boolean drawTop;
    private transient boolean drawBottom;
    private transient boolean drawLeft;
    private transient boolean drawRight;
    private transient boolean noDesignTimeBorder = false;
    private transient int borderType;
    private transient EclPanePage controller = null;

    public EclPanePageView(EclPanePage eclPanePage) {
        if (eclPanePage == null) {
            System.out.println("ERROR: EclPanePageView: Constructor: Null controller in constructor! Unable to initialize.");
        }
        this.controller = eclPanePage;
    }

    private Color getBackground() {
        return this.controller.getBackground();
    }

    private Color getForeground() {
        return this.controller.getForeground();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void notifyEclipseContainerChanged() {
        this.controller.validate();
        this.controller.repaint();
    }

    public void paintAfterChildren(Graphics graphics) {
        Color color = this.controller.getVisibleBackground().brighter();
        Color color2 = this.controller.getVisibleBackground().darker();
        Rectangle rectangle = this.controller.getBounds();
        if (Beans.isDesignTime() && !this.noDesignTimeBorder) {
            graphics.setColor(this.controller.getVisibleBackground().darker());
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        int n = 0;
        int n2 = rectangle.width - 1;
        int n3 = 0;
        int n4 = rectangle.height - 1;
        switch (this.borderType) {
            case 0: {
                graphics.setColor(this.getForeground());
                if (this.drawTop) {
                    graphics.drawLine(n, n3, n2, n3);
                }
                if (this.drawBottom) {
                    graphics.drawLine(n, n4, n2, n4);
                }
                if (this.drawLeft) {
                    graphics.drawLine(n, n3, n, n4);
                }
                if (!this.drawRight) break;
                graphics.drawLine(n2, n3, n2, n4);
                break;
            }
            case 1: 
            case 2: {
                graphics.setColor(this.borderType == 1 ? color : color2);
                if (this.drawTop) {
                    graphics.drawLine(n, n3, n2, n3);
                }
                if (this.drawBottom) {
                    graphics.drawLine(n + 1, n4 - 1, n2 - 1, n4 - 1);
                }
                if (this.drawLeft) {
                    graphics.drawLine(n, n3, n, n4);
                }
                if (this.drawRight) {
                    graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n4 - 1);
                }
                graphics.setColor(this.borderType == 1 ? color2 : color);
                if (this.drawTop) {
                    graphics.drawLine(n + 1, n3 + 1, n2 - 1, n3 + 1);
                }
                if (this.drawBottom) {
                    graphics.drawLine(n, n4, n2, n4);
                }
                if (this.drawLeft) {
                    graphics.drawLine(n + 1, n3 + 1, n + 1, n4 - 2);
                }
                if (!this.drawRight) break;
                graphics.drawLine(n2, n3 + 1, n2, n4);
                break;
            }
            case 3: 
            case 4: {
                graphics.setColor(this.borderType == 3 ? color : color2);
                if (this.drawTop) {
                    graphics.drawLine(n, n3, n2, n3);
                    graphics.drawLine(n + 1, n3 + 1, n2 - 1, n3 + 1);
                }
                if (this.drawLeft) {
                    graphics.drawLine(n, n3, n, n4);
                    graphics.drawLine(n + 1, n3 + 1, n + 1, n4 - 2);
                }
                graphics.setColor(this.borderType == 3 ? color2 : color);
                if (this.drawBottom) {
                    graphics.drawLine(n, n4, n2, n4);
                    graphics.drawLine(n + 1, n4 - 1, n2 - 1, n4 - 1);
                }
                if (!this.drawRight) break;
                graphics.drawLine(n2, n3 + 1, n2, n4);
                graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n4 - 1);
                break;
            }
            default: {
                System.out.println("ERROR: EclPanePageView: paintAfterChildren: unknown border type");
            }
        }
    }

    public void paintBeforeChildren(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.controller.getBounds().width, this.controller.getBounds().height);
        }
    }

    void setBorderType(int n) {
        this.borderType = n;
    }

    void setDrawBottom(boolean bl) {
        this.drawBottom = bl;
    }

    void setDrawLeft(boolean bl) {
        this.drawLeft = bl;
    }

    void setDrawRight(boolean bl) {
        this.drawRight = bl;
    }

    void setDrawTop(boolean bl) {
        this.drawTop = bl;
    }

    void setNoDesignTimeBorder(boolean bl) {
        this.noDesignTimeBorder = bl;
    }
}

