/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane;

import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskAccessor;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPane;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.EclTabbedPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.EclTabbedPaneView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclTabbedPane
extends EclPane {
    private transient EclTabbedPaneView view = null;
    private transient boolean hasFocus = false;
    private transient Font myFont = null;
    private transient Color myForegroundColor = null;
    private transient ApplicationGenericMetaData metaData = null;
    private transient ContextHelpController contextHelpController = null;

    protected EclPaneModel createDefaultModel() {
        EclTabbedPaneModel eclTabbedPaneModel = new EclTabbedPaneModel();
        return eclTabbedPaneModel;
    }

    /*
     * Unable to fully structure code
     */
    private ContextHelpController getContextHelpController() {
        block2: {
            if (this.contextHelpController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof ContextHelpController)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement ContextHelpController");
            }
            this.contextHelpController = (ContextHelpController)var1_1;
        }
        return this.contextHelpController;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.view;
    }

    public EclTabbedPaneView getEclTabbedPaneView() {
        return this.view;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getForeground() {
        return this.myForegroundColor;
    }

    private ApplicationMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new ApplicationGenericMetaData();
            try {
                PrimitiveTypesWriter primitiveTypesWriter = this.metaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(this.getEclModel().getCompositeDataID());
                this.metaData.completedMetaDataInitialisation();
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": getMetaData: Creation of meta data failed!");
                this.metaData = null;
            }
        }
        return this.metaData;
    }

    private EclTabbedPaneModel getModel() {
        return (EclTabbedPaneModel)this.getEclModel();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected boolean hasView() {
        return true;
    }

    protected void initialise() {
        this.setSize(300, 100);
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.enableEvents(12L);
    }

    protected void initialiseModel() {
        if (this.view == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    int mapCompleteListIndexToIndex(MaskedIntegerValue maskedIntegerValue) {
        MaskAccessor maskAccessor = maskedIntegerValue.getOptionMask();
        if (!this.getModel().isShowingGreyedTabs()) {
            maskAccessor = maskAccessor.createAND(maskedIntegerValue.getStateMask());
        }
        int n = -1;
        for (int i = -1; i != maskedIntegerValue.getValue(); ++i) {
            try {
                if (!maskAccessor.query(i)) continue;
                ++n;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                EventLog.instance().log(String.valueOf(this.toString()) + " has an Option Mask incomplete");
                return -1;
            }
        }
        return n;
    }

    private int mapIndexToCompleteListIndex(int n) {
        MaskAccessor maskAccessor = this.thePreviousIndexValue.getOptionMask();
        if (!this.getModel().isShowingGreyedTabs()) {
            maskAccessor = maskAccessor.createAND(this.thePreviousIndexValue.getStateMask());
        }
        int n2 = -1;
        int n3 = -1;
        if (this.thePreviousIndexValue != null) {
            while (n2 != n) {
                ++n3;
                try {
                    if (!maskAccessor.query(n3)) continue;
                    ++n2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    EventLog.instance().log(String.valueOf(this.toString()) + " has an Option Mask incomplete");
                    return -1;
                }
            }
            return n3;
        }
        EventLog.instance().log(String.valueOf(this.toString()) + " has no Option Mask defined");
        return -1;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    this.getContextHelpController().removeContextHelp(this.getModel().getHelpIDForIndex(this.thePreviousIndexValue));
                    return;
                }
                this.hasFocus = true;
                this.getContextHelpController().displayContextHelp(this.getModel().getHelpIDForIndex(this.thePreviousIndexValue));
                break;
            }
            case 1005: {
                this.hasFocus = false;
                this.getContextHelpController().removeContextHelp(this.getModel().getHelpIDForIndex(this.thePreviousIndexValue));
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclTabbedPaneView().processKeyEvent(keyEvent);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        boolean bl = this.hasTrappedTransientError;
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                if (this.hasFocus()) {
                    this.getContextHelpController().displayContextHelp(this.getModel().getHelpIDForIndex(maskedIntegerValue));
                }
                if (bl || maskedIntegerValue.hasDifferentMasks(this.thePreviousIndexValue)) {
                    bl = !this.getModel().updatedViewWithNewMasks(maskedIntegerValue);
                    this.repaint();
                } else {
                    bl = !this.getEclTabbedPaneView().setSelectedIndex(this.mapCompleteListIndexToIndex(maskedIntegerValue));
                    this.repaint();
                }
                super.receiveMaskedIntegerData(maskedIntegerValue, applicationDataSender);
                if (bl && !this.hasTrappedTransientError) {
                    this.trapTransientError(true);
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void removeNotify() {
        this.hasFocus = false;
        super.removeNotify();
    }

    public void requestFocus() {
        if (this.isFocusTraversable() && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public void setEclTabbedPaneView(EclTabbedPaneView eclTabbedPaneView) {
        this.view = eclTabbedPaneView;
    }

    public void setFont(Font font) {
        this.myFont = font;
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setForeground(Color color) {
        this.myForegroundColor = color;
        super.setForeground(color);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setSelectedIndex(int n) {
        int n2 = this.mapIndexToCompleteListIndex(n);
        if (n2 != -1) {
            if (n2 == this.thePreviousIndexValue.getValue()) {
                return;
            }
            MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n2, this.thePreviousIndexValue);
            if (this.getEclModel().getCompositeDataID() != -1) {
                maskedIntegerValue.describe(this.getMetaData());
            }
            if (!this.theApplicationObject.change(maskedIntegerValue)) {
                EclipseSystem.instance().beep();
                EventLog.instance().log(String.valueOf(this.toString()) + " Error: Requested change failed.");
                this.getEclTabbedPaneView().setSelectedIndex(this.mapCompleteListIndexToIndex(this.thePreviousIndexValue));
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not find the index in the model associated to the selection.");
            this.permanentError();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclTabbedPane" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void unregister() {
        super.unregister();
        this.getEclTabbedPaneView().unregister();
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }
}

