/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskAccessor;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTabbedPaneDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.AccessibleEclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.AccessibleEclTabbedPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.EclTabbedPane;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.EclTabbedPaneView;
import com.sun.java.util.collections.Arrays;
import java.awt.Component;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclTabbedPaneModel
extends EclPaneModel
implements Serializable {
    static final long serialVersionUID = -676123195255537771L;
    private String[] tabCaptions = null;
    private String[] helpIds = null;
    private int tabHeight;
    private boolean showGreyedTabs = true;

    public EclTabbedPaneModel() {
        this.tabCaptions = null;
        this.helpIds = null;
        this.tabHeight = 23;
    }

    public EclTabbedPaneModel(EclPaneModel eclPaneModel, String[] stringArray, String[] stringArray2, int n, boolean bl) {
        super(eclPaneModel);
        this.tabCaptions = stringArray;
        this.helpIds = stringArray2;
        this.tabHeight = n;
        this.showGreyedTabs = bl;
    }

    private boolean areIndexValuesConsistent(MaskedIntegerValue maskedIntegerValue) {
        if (maskedIntegerValue == null) {
            return false;
        }
        try {
            if (!maskedIntegerValue.getOptionMask().query(maskedIntegerValue.getValue())) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: cannot select miv.getValue " + maskedIntegerValue.getValue() + " ,because option mask is false (correspond to item not available in the list).");
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: option mask too short for miv.getValue " + maskedIntegerValue.getValue());
            return false;
        }
        try {
            if (!maskedIntegerValue.getStateMask().query(maskedIntegerValue.getValue())) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: cannot select miv.getValue " + maskedIntegerValue.getValue() + " ,because state mask is false (correspond to greyed item in the list).");
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: state mask too short for miv.getValue " + maskedIntegerValue.getValue());
            return false;
        }
        return true;
    }

    protected AccessibleEclPaneModel createAccessibleModel() {
        return this.getAccessibleModel();
    }

    private GreyableString[] createListView(MaskedIntegerValue maskedIntegerValue) {
        int n = 0;
        MaskAccessor maskAccessor = maskedIntegerValue.getOptionMask();
        if (!this.showGreyedTabs) {
            maskAccessor = maskAccessor.createAND(maskedIntegerValue.getStateMask());
        }
        int n2 = maskAccessor.countSetBits();
        GreyableString[] greyableStringArray = new GreyableString[n2];
        int n3 = 0;
        while (n3 < this.tabCaptions.length) {
            try {
                if (maskAccessor.query(n3)) {
                    greyableStringArray[n++] = new GreyableString(this.tabCaptions[n3], maskedIntegerValue.getStateMask().query(n3));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " has an Option Mask or State mask incomplete: impossible to create the list of items");
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " has an Option Mask or State mask too big: impossible to create the list of items");
                return null;
            }
            ++n3;
        }
        if (n != greyableStringArray.length) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Incompatible mask length for this list of elements");
            return null;
        }
        return greyableStringArray;
    }

    public void createView() {
        super.createView();
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclTabbedPaneDefaults.background);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclTabbedPaneDefaults.foreground);
        }
        if (this.getController().getFont() == null) {
            ((Component)this.getController()).setFont(EclTabbedPaneDefaults.font);
        }
        if (this.getTabbedPaneController().getEclTabbedPaneView() == null) {
            this.getTabbedPaneController().setEclTabbedPaneView(new EclTabbedPaneView(this.getTabbedPaneController()));
        }
        if (Beans.isDesignTime() && this.tabCaptions != null) {
            GreyableString[] greyableStringArray = new GreyableString[this.tabCaptions.length];
            int n = 0;
            while (n < this.tabCaptions.length) {
                greyableStringArray[n] = new GreyableString(this.tabCaptions[n], true);
                ++n;
            }
            this.getTabbedPaneController().getEclTabbedPaneView().initialise(greyableStringArray, this.tabHeight);
        }
    }

    AccessibleEclTabbedPaneModel getAccessibleModel() {
        return new AccessibleEclTabbedPaneModel(super.createAccessibleModel(), this.tabCaptions, this.helpIds, this.tabHeight, this.showGreyedTabs, this.getTabbedPaneController());
    }

    public String getHelpIDForIndex(MaskedIntegerValue maskedIntegerValue) {
        return maskedIntegerValue == null ? null : this.helpIds[maskedIntegerValue.getValue()];
    }

    private EclTabbedPane getTabbedPaneController() {
        return (EclTabbedPane)this.getController();
    }

    public void initialiseDefaults() {
        this.getController().setBackground(EclTabbedPaneDefaults.background);
        this.getController().setForeground(EclTabbedPaneDefaults.foreground);
        ((Component)this.getController()).setFont(EclTabbedPaneDefaults.font);
    }

    boolean isShowingGreyedTabs() {
        return this.showGreyedTabs;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.tabCaptions = (String[])objectInputStream.readObject();
                this.helpIds = (String[])objectInputStream.readObject();
                this.tabHeight = objectInputStream.readInt();
                this.showGreyedTabs = objectInputStream.readBoolean();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclTabbedPaneModel";
                throw new IOException(string);
            }
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + (this.tabCaptions == null ? "no captions" : Arrays.asList((Object[])this.tabCaptions).toString());
    }

    public boolean updatedViewWithNewMasks(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = false;
        if (this.areIndexValuesConsistent(maskedIntegerValue)) {
            this.getTabbedPaneController().getEclTabbedPaneView().initialise(this.createListView(maskedIntegerValue), this.tabHeight);
            bl = this.getTabbedPaneController().getEclTabbedPaneView().setSelectedIndex(this.getTabbedPaneController().mapCompleteListIndexToIndex(maskedIntegerValue));
        } else {
            this.getTabbedPaneController().getEclTabbedPaneView().initialise(null, this.tabHeight);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.tabCaptions);
        objectOutputStream.writeObject(this.helpIds);
        objectOutputStream.writeInt(this.tabHeight);
        objectOutputStream.writeBoolean(this.showGreyedTabs);
    }
}

