/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclTabbedPaneDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.EclTabbedPane;
import com.agilent.tntd.eclipse.viewlayer.containers.tabbedpane.TransparentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public class EclTabbedPaneView
implements EclipseContainerView {
    private EclTabbedPane controller = null;
    private int tabHeight = 23;
    private GreyableString[] captions = null;
    private int[] widths = null;
    private int selectedIndex = 0;
    private Insets myInsets = new Insets(this.tabHeight + 4, 4, 4, 4);
    private transient UnconsumedKeyHandler mainKeyController = null;
    private TransparentTab[] theTransparentTabs;

    public EclTabbedPaneView(EclTabbedPane eclTabbedPane) {
        if (eclTabbedPane == null) {
            System.out.println("ERROR: EclTabbedPaneView: Constructor: Null controller in constructor! Unable to initialize.");
        }
        this.controller = eclTabbedPane;
    }

    private Color getBackground() {
        return this.controller.getBackground();
    }

    private Rectangle getBounds() {
        return this.controller.getBounds();
    }

    private Font getFont() {
        return this.controller.getFont();
    }

    private Color getForeground() {
        return this.controller.getForeground();
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (this.mainKeyController != null) break block2;
            var1_1 = this.controller.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.controller.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            this.mainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return this.mainKeyController;
    }

    void initialise(GreyableString[] greyableStringArray, int n) {
        this.captions = greyableStringArray;
        this.tabHeight = Math.max(n, 1);
        this.notifyEclipseContainerChanged();
    }

    public void notifyEclipseContainerChanged() {
        this.myInsets.top = this.tabHeight + 4;
        if (this.captions != null && this.getFont() != null) {
            FontMetrics fontMetrics = this.controller.getFontMetrics(this.getFont());
            if (this.theTransparentTabs == null) {
                this.theTransparentTabs = new TransparentTab[this.captions.length];
            } else if (this.theTransparentTabs.length != this.captions.length) {
                int n = 0;
                while (n < this.theTransparentTabs.length) {
                    this.controller.getParent().remove(this.theTransparentTabs[n]);
                    ++n;
                }
                this.theTransparentTabs = new TransparentTab[this.captions.length];
            }
            this.widths = new int[this.captions.length];
            int n = this.controller.getBounds().x;
            int n2 = this.controller.getBounds().y;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.captions.length) {
                this.widths[n4] = fontMetrics.stringWidth(this.captions[n4].getValue()) + 16;
                TransparentTab transparentTab = this.theTransparentTabs[n4];
                if (transparentTab == null) {
                    this.theTransparentTabs[n4] = transparentTab = new TransparentTab(this.controller, n4);
                }
                transparentTab.setBounds(n + n3, n2, this.widths[n4], this.tabHeight);
                n3 += this.widths[n4];
                if (!Beans.isDesignTime()) {
                    this.controller.getParent().add((Component)transparentTab, 0);
                }
                ++n4;
            }
        }
    }

    public void paintAfterChildren(Graphics graphics) {
        int n = this.getBounds().height;
        int n2 = this.getBounds().width;
        graphics.setColor(Color.white);
        graphics.drawLine(0, this.tabHeight, 0, n - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.drawLine(n2 - 1, this.tabHeight, n2 - 1, n - 1);
        graphics.setColor(Color.gray);
        graphics.drawLine(1, n - 2, n2 - 2, n - 2);
        graphics.drawLine(n2 - 2, this.tabHeight, n2 - 2, n - 2);
        this.paintTabs(graphics);
    }

    public void paintBeforeChildren(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, this.tabHeight, this.getBounds().width, this.getBounds().height - this.tabHeight);
        }
    }

    private void paintTab(Graphics graphics, int n, int n2, int n3, int n4, GreyableString greyableString, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n5;
        int n6 = bl ? n : n + 2;
        int n7 = bl ? n2 : n2 + 2;
        int n8 = bl ? n3 : n3 - 4;
        int n9 = n5 = bl ? n4 : n4 - 3;
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n6 + 2, n7 + 1, n8 - 4, n5);
        }
        if (this.getFont() != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n10 = fontMetrics.stringWidth(greyableString.getValue());
            int n11 = n + (n3 - n10) / 2;
            int n12 = n2 + (n4 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
            if (greyableString.getState()) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString(greyableString.getValue(), n11, n12);
        }
        graphics.setColor(Color.white);
        graphics.drawLine(n6 + 2, n7, n6 + n8 - 3, n7);
        if (!bl2) {
            if (this.getBackground() != null) {
                graphics.setColor(this.getBackground());
                graphics.drawLine(n6 + 1, n7 + 2, n6 + 1, n7 + n5 - 1);
            }
            graphics.setColor(Color.white);
            graphics.drawLine(n6, n7 + 2, n6, n7 + n5 - 1);
            graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n7 + 1);
        }
        if (!bl3) {
            graphics.setColor(Color.black);
            graphics.drawLine(n6 + n8 - 1, n7 + 2, n6 + n8 - 1, n7 + n5 - 1);
            graphics.setColor(Color.gray);
            graphics.drawLine(n6 + n8 - 2, n7 + 1, n6 + n8 - 2, n7 + n5 - 1);
        }
        if (!bl) {
            graphics.setColor(Color.white);
            graphics.drawLine(bl2 ? n + 4 : n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        } else if (this.controller.hasFocus()) {
            graphics.setColor(EclTabbedPaneDefaults.focusColour);
            graphics.drawRect(n + 4, n2 + 4, n3 - 8 - 1, n4 - 8);
        }
    }

    private void paintTabs(Graphics graphics) {
        int n = this.captions == null ? 0 : this.captions.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = this.widths[n4];
            this.paintTab(graphics, n3, 0, n2 + 4, this.tabHeight, this.captions[n4], n4 == this.selectedIndex, n4 == this.selectedIndex + 1, n4 == this.selectedIndex - 1, this.controller.hasFocus());
            n3 += n2;
            ++n4;
        }
        graphics.setColor(Color.white);
        graphics.drawLine(this.selectedIndex == n - 1 ? n3 + 4 : n3, this.tabHeight - 1, this.getBounds().width - 1, this.tabHeight - 1);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 37: {
                    this.selectPreviousTab(this.selectedIndex);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.selectNextTab(this.selectedIndex);
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.controller);
        }
    }

    private void selectNextTab(int n) {
        while (++n < this.captions.length && !this.captions[n].getState()) {
        }
        if (n == this.captions.length) {
            this.selectPreviousTab(n);
        } else {
            this.controller.setSelectedIndex(n);
        }
    }

    private void selectPreviousTab(int n) {
        while (--n > -1 && !this.captions[n].getState()) {
        }
        if (n < 0) {
            this.selectNextTab(n);
        } else {
            this.controller.setSelectedIndex(n);
        }
    }

    boolean setSelectedIndex(int n) {
        boolean bl;
        boolean bl2 = bl = this.captions != null && this.captions.length > n && n > -1;
        if (bl) {
            this.selectedIndex = n;
        }
        return bl;
    }

    public void unregister() {
        this.theTransparentTabs = null;
    }
}

