/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.window;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainer;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLabelDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.architecture.text.TextHelper;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowView;
import com.agilent.tntd.eclipse.viewlayer.hooks.AbstractHook;
import com.agilent.tntd.eclipse.viewlayer.hooks.HookHandler;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EclWindow
extends EclipseContainer
implements InternalWindow,
HookHandler {
    private EclWindowModel eclModel = null;
    private transient Font myFont;
    private transient Color myForeground;
    private transient boolean selected;
    private transient EclWindowView eclWindowView;
    private transient UnconsumedKeyHandler theMainKeyController = null;
    private transient ArrayList theHookList = null;
    private transient boolean hasInitialised = false;
    private transient EclPanePage theContextPanel;

    public EclWindow() {
        this.enableEvents(28L);
        this.setLayout(null);
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
    }

    public Component activateMethod(String string) {
        Class<?> clazz = null;
        Component component = null;
        try {
            clazz = this.getClass();
            Method method = clazz.getDeclaredMethod(string, null);
            component = this.getComponentFromMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.failToCreateComponent(noSuchMethodException, string, clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.failToCreateComponent(invocationTargetException, string, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.failToCreateComponent(illegalAccessException, string, clazz);
        }
        return component;
    }

    public void addHook(AbstractHook abstractHook) {
        EclWindow eclWindow = this;
        synchronized (eclWindow) {
            if (this.hasInitialised) {
                EclipseSystem.instance().exitWithError("Eclipse doesn't allow to add a hook: " + abstractHook + " when the Hook Handler: " + this.toString() + " has been initialised");
            } else {
                if (this.theHookList == null) {
                    this.theHookList = new ArrayList();
                }
                this.theHookList.add((Object)abstractHook);
            }
        }
    }

    protected void connectToWorkspace(EclipseWorkspace eclipseWorkspace) {
        this.getEclModel().connectToWorkspace(eclipseWorkspace, null);
    }

    public void connectWithWorkspace(EclipseWorkspace eclipseWorkspace) {
        this.connectToWorkspace(eclipseWorkspace);
    }

    private void failToCreateComponent(Exception exception, String string, Class clazz) {
        System.out.println("Reflection error cannot see method= " + exception.toString());
        System.out.println(string);
        if (clazz != null) {
            System.out.println("class = " + clazz.toString());
        }
    }

    public void finishInitialise() {
        Component[] componentArray = this;
        synchronized (this) {
            int n;
            this.hasInitialised = true;
            if (this.theHookList != null) {
                n = 0;
                while (n < this.theHookList.size()) {
                    ((AbstractHook)this.theHookList.get(n)).finishInitialise();
                    ++n;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            componentArray = this.getComponents();
            n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof CcComponent) {
                    ((CcComponent)((Object)componentArray[n])).finishInitialise();
                }
                ++n;
            }
            return;
        }
    }

    protected Component focusTopLeftComponent() {
        return EclipseFocusManager.getInstance().focusFirstComponent(this);
    }

    protected Component getComponentFromMethod(Method method) throws IllegalAccessException, InvocationTargetException {
        return null;
    }

    public final Container getContainer() {
        return this;
    }

    private EclPanePage getContextPanel() {
        if (this.theContextPanel == null) {
            this.theContextPanel = new EclPanePage();
            Insets insets = this.getInsets();
            this.theContextPanel.setBounds(insets.left, insets.top, this.getBounds().width - insets.left - insets.right, this.getBounds().height - insets.top - insets.bottom);
            this.theContextPanel.setBackground(this.getVisibleBackground());
            this.theContextPanel.setVisible(false);
            this.add((Component)this.theContextPanel, 0);
            TextHelper.populateWithText(this.theContextPanel, "Not in context.", this.theContextPanel.getBounds().width, EclLabelDefaults.font);
        }
        return this.theContextPanel;
    }

    protected EclipseContainerView getEclipseContainerView() {
        return this.getEclWindowView();
    }

    public EclWindowModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclWindowModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public EclWindowView getEclWindowView() {
        return this.eclWindowView;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (this.theMainKeyController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException();
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            this.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return this.theMainKeyController;
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclWindowView == null) {
            this.getEclModel().createView();
        }
    }

    private boolean isComponentReallyVisible(Component component) {
        boolean bl = false;
        if (component.isVisible()) {
            Container container = component.getParent();
            while (container != null) {
                if (!container.isVisible() || container == this) break;
                container = container.getParent();
            }
            if (container == this) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isSelectable() {
        return this.getEclModel().isSelectable();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void notifyContextChange(boolean bl) {
        if (bl) {
            if (this.theContextPanel != null) {
                this.getContextPanel().setVisible(false);
            }
            this.repaint();
        } else {
            this.getContextPanel().setVisible(true);
            this.repaint();
        }
        if (this.isSelected()) {
            if (bl) {
                this.focusTopLeftComponent();
            } else {
                this.requestFocus();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.focusTopLeftComponent();
                    keyEvent.consume();
                    break;
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isSelected()) {
            if (mouseEvent.getID() == 500 && GenericMouseHelper.isRightMouseButton(mouseEvent)) {
                Component component = EclipseFocusManager.getInstance().getWindowFocusedComponent();
                this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(component), component);
            }
        } else if (mouseEvent.getID() == 504) {
            EclipseFocusManager.getInstance().attemptSelectWindow(this);
        }
    }

    public void requestFocus() {
        if (this.isFocusTraversable() && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 == 1 && n4 == 1 && n == 20 && n2 == 20) {
            super.setBounds(20, 20, 150, 150);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void setEclModel(EclWindowModel eclWindowModel) {
        this.eclModel = eclWindowModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setEclWindowView(EclWindowView eclWindowView) {
        this.eclWindowView = eclWindowView;
    }

    public void setFont(Font font) {
        this.myFont = font;
        super.setFont(font);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setForeground(Color color) {
        this.myForeground = color;
        super.setForeground(color);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public Component setSelected(boolean bl, Component component) {
        Component component2 = component;
        this.selected = bl;
        if (bl) {
            this.setVisible(true);
            if (component != null && component.isFocusTraversable() && component.isEnabled() && this.isComponentReallyVisible(component)) {
                component.requestFocus();
            } else {
                component2 = this.focusTopLeftComponent();
            }
        }
        return component2;
    }

    public void unregister() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
        EclWindow eclWindow = this;
        synchronized (eclWindow) {
            if (this.theHookList != null) {
                int n2 = 0;
                while (n2 < this.theHookList.size()) {
                    ((AbstractHook)this.theHookList.get(n2)).unregister();
                    ++n2;
                }
            }
            this.hasInitialised = false;
        }
    }
}

