/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.window;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclWindowDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.window.AccessibleEclWindowModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowView;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowKeyConsumer;
import java.awt.Color;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclWindowModel
implements Serializable {
    static final long serialVersionUID = 829511851250431321L;
    private transient EclWindow controller;
    private int windowLocation;
    private int titleToBorderGap;
    private int bevelWidth;
    private Color titleBarBackgroundColor;
    private String windowTitle;

    public EclWindowModel() {
        this.windowLocation = 0;
        this.titleToBorderGap = 3;
        this.bevelWidth = 2;
        this.titleBarBackgroundColor = new Color(69, 120, 190);
        this.windowTitle = "Unknown Title";
    }

    public EclWindowModel(int n, int n2, int n3, Color color, String string) {
        this.windowLocation = n;
        this.titleToBorderGap = n2;
        this.bevelWidth = n3;
        this.titleBarBackgroundColor = color;
        this.windowTitle = string;
    }

    public void connectToWorkspace(EclipseWorkspace eclipseWorkspace, UnconsumedKeyHandler unconsumedKeyHandler) {
        if (this.windowLocation == 0 && unconsumedKeyHandler == null) {
            unconsumedKeyHandler = new ModalWindowKeyConsumer(this.getController());
        }
        eclipseWorkspace.addInternalWindow(this.getController(), this.windowLocation, unconsumedKeyHandler);
    }

    protected AccessibleEclWindowModel createAccessibleModel() {
        return new AccessibleEclWindowModel(this.windowLocation, this.titleToBorderGap, this.bevelWidth, this.titleBarBackgroundColor, this.windowTitle, this.getController());
    }

    public void createView() {
        switch (this.windowLocation) {
            case 1: {
                this.getController().setBounds(InternalWindow.BOUNDS_LEFT);
                break;
            }
            case 2: {
                this.getController().setBounds(InternalWindow.BOUNDS_RIGHT);
                break;
            }
            case 3: {
                this.getController().setBounds(InternalWindow.BOUNDS_DOUBLE);
                break;
            }
            case 4: {
                this.getController().setBounds(InternalWindow.BOUNDS_FULL);
                break;
            }
            case 6: {
                this.getController().setBounds(InternalWindow.BOUNDS_HELP);
                break;
            }
            case 5: {
                this.getController().setBounds(InternalWindow.BOUNDS_SUMMARY);
            }
        }
        if (Beans.isDesignTime() && this.windowLocation != 0) {
            this.getController().setLocation(20, 20);
        }
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclWindowDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclWindowDefaults.font);
        }
        if (this.getController().getEclWindowView() == null) {
            this.getController().setEclWindowView(new EclWindowView(this.getController()));
        }
        this.getController().getEclWindowView().initialiseWindowProperties(this.windowTitle);
    }

    private EclWindow getController() {
        return this.controller;
    }

    public void initialiseDefaults() {
        this.getController().setFont(EclWindowDefaults.font);
        this.getController().setBackground(EclWindowDefaults.background);
    }

    public boolean isSelectable() {
        return this.windowLocation != 5;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.readInt();
        this.windowLocation = objectInputStream.readInt();
        this.titleToBorderGap = objectInputStream.readInt();
        this.bevelWidth = objectInputStream.readInt();
        this.titleBarBackgroundColor = (Color)objectInputStream.readObject();
        this.windowTitle = (String)objectInputStream.readObject();
    }

    public void setController(EclWindow eclWindow) {
        this.controller = eclWindow;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(this.windowLocation);
        objectOutputStream.writeInt(this.titleToBorderGap);
        objectOutputStream.writeInt(this.bevelWidth);
        objectOutputStream.writeObject(this.titleBarBackgroundColor);
        objectOutputStream.writeObject(this.windowTitle);
    }
}

