/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.window;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclWindowDefaults;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;

public class EclWindowView
implements EclipseContainerView {
    private EclWindow myController;
    private int titleHeight;
    private String title;
    private Point titleOrigin = new Point(0, 0);
    private Point insideOrigin = new Point(0, 0);
    private int insideWidth = 0;
    private int insideHeight = 0;
    private static final Color activeHighlight = EclWindowDefaults.activeBorderColour.brighter();
    private static final Color activeShadow = EclWindowDefaults.activeBorderColour.darker();
    private static final Color inactiveHighlight = EclWindowDefaults.inactiveBorderColour.brighter();
    private static final Color inactiveShadow = EclWindowDefaults.inactiveBorderColour.darker();

    public EclWindowView(EclWindow eclWindow) {
        this.myController = eclWindow;
        if (this.myController != null) {
            this.notifyEclipseContainerChanged();
        }
    }

    private void calculateGeometry() {
        if (this.title == null || this.title.length() == 0) {
            this.titleHeight = 0;
            this.insideOrigin.x = 2;
            this.insideOrigin.y = 2;
            this.insideWidth = this.myController.getSize().width - 4;
            this.insideHeight = this.myController.getSize().height - 4;
        } else {
            FontMetrics fontMetrics = this.myController.getFontMetrics(this.myController.getFont());
            this.titleHeight = 6 + fontMetrics.getHeight();
            this.titleOrigin.x = 6;
            this.titleOrigin.y = 4 + fontMetrics.getAscent();
            this.insideOrigin.x = 2;
            this.insideOrigin.y = this.titleHeight;
            this.insideWidth = this.myController.getSize().width - 4;
            this.insideHeight = this.myController.getSize().height - this.insideOrigin.y - 2;
        }
    }

    public Insets getInsets() {
        if (this.title != null && this.title.length() > 0) {
            return new Insets(this.titleHeight + 2, 4, 4, 4);
        }
        return new Insets(4, 4, 4, 4);
    }

    public void initialiseWindowProperties(String string) {
        this.title = string;
        this.calculateGeometry();
    }

    public void notifyEclipseContainerChanged() {
        this.calculateGeometry();
    }

    private void paint3DHighlights(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = 0;
        while (n8 < n5) {
            graphics.setColor(bl ? color : color2);
            graphics.drawLine(n + n8, n2 + n8, n6 - n8, n2 + n8);
            graphics.drawLine(n + n8, n2 + n8, n + n8, n7 - n8);
            graphics.setColor(bl ? color2 : color);
            graphics.drawLine(n6 - n8, n2 + n8, n6 - n8, n7 - n8);
            graphics.drawLine(n + n8, n7 - n8, n6 - n8, n7 - n8);
            ++n8;
        }
    }

    public void paintAfterChildren(Graphics graphics) {
        if (this.title != null && this.title.length() > 0) {
            this.paintTitleBar(graphics);
        }
        this.paintBorder(graphics);
    }

    public void paintBeforeChildren(Graphics graphics) {
        if (this.myController.getBackground() != null) {
            graphics.setColor(this.myController.getBackground());
            graphics.fillRect(0, 0, this.myController.getBounds().width, this.myController.getBounds().height);
        }
    }

    private void paintBorder(Graphics graphics) {
        Color color = this.myController.isSelected() ? activeHighlight : inactiveHighlight;
        Color color2 = this.myController.isSelected() ? activeShadow : inactiveShadow;
        this.paint3DHighlights(graphics, 0, 0, this.myController.getSize().width, this.myController.getSize().height, 2, color, color2, true);
        this.paint3DHighlights(graphics, this.insideOrigin.x, this.insideOrigin.y, this.insideWidth, this.insideHeight, 2, color, color2, false);
    }

    private void paintTitleBar(Graphics graphics) {
        Color color = this.myController.isSelected() ? EclWindowDefaults.activeBorderColour : EclWindowDefaults.inactiveBorderColour;
        Color color2 = this.myController.isSelected() ? EclWindowDefaults.activeTitleColour : EclWindowDefaults.inactiveTitleColour;
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.myController.getBounds().width, this.titleHeight);
        graphics.setColor(color2);
        graphics.setFont(this.myController.getFont());
        graphics.drawString(this.title, this.titleOrigin.x, this.titleOrigin.y);
    }
}

