/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.window;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;

public class ModalWindowKeyConsumer
implements UnconsumedKeyHandler {
    private InternalWindow myWindow;

    public ModalWindowKeyConsumer(InternalWindow internalWindow) {
        this.myWindow = internalWindow;
    }

    public void processUnconsumedKeyEvents(KeyEvent keyEvent, Component component) {
        switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
            case 107: 
            case 113: 
            case 119: {
                keyEvent.consume();
                break;
            }
            case 27: {
                if (keyEvent.getID() == 401) {
                    this.removeModalWindow();
                }
                keyEvent.consume();
            }
        }
    }

    private boolean removeModalWindow() {
        boolean bl = false;
        if (this.myWindow != null) {
            Container container = this.myWindow.getContainer();
            while (container.getParent() != null) {
                container = container.getParent();
            }
            if (container instanceof EclipseWorkspace) {
                bl = ((EclipseWorkspace)((Object)container)).removeWindow(this.myWindow, true);
            }
        }
        return bl;
    }
}

