/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import java.awt.Component;
import java.awt.event.KeyEvent;

class InstrumentKeyHandlers
implements CcComponent,
ApplicationObjectObserver,
UnconsumedKeyHandler {
    private EclipseWorkspace myWorkspace;
    private final String resetKeyName;
    private final String runStopKeyName;
    private final String singleErrorKeyName;
    private ApplicationObject theResetKeyApplicationObject = null;
    private ApplicationObject theRunStopKeyApplicationObject = null;
    private ApplicationObject theSingleErrorKeyApplicationObject = null;
    private final String thePrintWindowName = "com.agilent.tntd.eclipse.thinclient.setup.Print_Control";
    private final String theShowMoreWindowName;
    private final String defaultPlatformShowMoreWindowName = "com.agilent.tntd.eclipse.thinclient.measurements.LEDs";

    public InstrumentKeyHandlers(EclipseWorkspace eclipseWorkspace, String string, String string2, String string3, String string4) {
        this.myWorkspace = eclipseWorkspace;
        this.runStopKeyName = string;
        this.resetKeyName = string2;
        this.singleErrorKeyName = string3;
        this.theShowMoreWindowName = string4 != null ? string4 : "com.agilent.tntd.eclipse.thinclient.measurements.LEDs";
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise one of its keys because " + applicationObject.toString() + " failed to initialise.");
            if (applicationObject.getName().equals(this.resetKeyName)) {
                this.theResetKeyApplicationObject = null;
            } else if (applicationObject.getName().equals(this.runStopKeyName)) {
                this.theRunStopKeyApplicationObject = null;
            } else {
                this.theSingleErrorKeyApplicationObject = null;
            }
            applicationObject.unregister(this);
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (applicationObject.getName().equals(this.resetKeyName)) {
            this.theResetKeyApplicationObject = applicationObject;
        } else if (applicationObject.getName().equals(this.runStopKeyName)) {
            this.theRunStopKeyApplicationObject = applicationObject;
        } else {
            this.theSingleErrorKeyApplicationObject = applicationObject;
        }
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.resetKeyName, (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, this.runStopKeyName, (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, this.singleErrorKeyName, (ApplicationObjectObserver)this);
    }

    private InternalWindow getInternalWindowFor(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof InternalWindow)) {
            component2 = component2.getParent();
        }
        if (component2 != null && !component2.getClass().getName().equals("com.agilent.tntd.eclipse.thinclient.setup.Print_Control") && !component2.getClass().getName().equals(this.theShowMoreWindowName)) {
            component2 = null;
        }
        return (InternalWindow)((Object)component2);
    }

    private void permanentError() {
        this.unregister();
    }

    private void printAction(InternalWindow internalWindow) {
        if (internalWindow != null) {
            if (internalWindow.getClass().getName().equals("com.agilent.tntd.eclipse.thinclient.setup.Print_Control") && this.myWorkspace.removeWindow(internalWindow, true)) {
                internalWindow = null;
            }
        } else {
            WindowManager.instance().createWindow("com.agilent.tntd.eclipse.thinclient.setup.Print_Control");
        }
    }

    public void processUnconsumedKeyEvents(KeyEvent keyEvent, Component component) {
        if (keyEvent.getID() == 401) {
            ApplicationObject applicationObject = null;
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 121: {
                    applicationObject = this.theResetKeyApplicationObject;
                    keyEvent.consume();
                    break;
                }
                case 116: {
                    applicationObject = this.theRunStopKeyApplicationObject;
                    keyEvent.consume();
                    break;
                }
                case 118: {
                    applicationObject = this.theSingleErrorKeyApplicationObject;
                    keyEvent.consume();
                    break;
                }
                case 120: {
                    this.showMoreAction(this.getInternalWindowFor(component));
                    if (component instanceof EclipseMenuElement) {
                        ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(false);
                    }
                    keyEvent.consume();
                    break;
                }
                case 117: {
                    if (component instanceof EclipseMenuElement) {
                        ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(false);
                    }
                    this.printAction(this.getInternalWindowFor(component));
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    InternalWindow internalWindow = this.getInternalWindowFor(component);
                    if (internalWindow == null || !this.myWorkspace.removeWindow(internalWindow, true)) break;
                    internalWindow = null;
                    keyEvent.consume();
                }
            }
            if (applicationObject != null) {
                applicationObject.change(null);
            }
        }
    }

    private void showMoreAction(InternalWindow internalWindow) {
        if (internalWindow != null && internalWindow.getContainer().getParent() != null) {
            if (internalWindow.getClass().getName().equals(this.theShowMoreWindowName) && this.myWorkspace.removeWindow(internalWindow, true)) {
                internalWindow = null;
            }
        } else {
            WindowManager.instance().createWindow(this.theShowMoreWindowName);
        }
    }

    public String toString() {
        return "the FrontPanel Keys handler";
    }

    public void unregister() {
        if (this.theResetKeyApplicationObject != null) {
            this.theResetKeyApplicationObject.unregister(this);
            this.theResetKeyApplicationObject = null;
        }
        if (this.theRunStopKeyApplicationObject != null) {
            this.theRunStopKeyApplicationObject.unregister(this);
            this.theRunStopKeyApplicationObject = null;
        }
        if (this.theSingleErrorKeyApplicationObject != null) {
            this.theSingleErrorKeyApplicationObject.unregister(this);
            this.theSingleErrorKeyApplicationObject = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        EventLog.instance().log(String.valueOf(this.toString()) + " should not receive an data from  " + applicationObject.toString());
        this.permanentError();
    }
}

