/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.MultiInstrumentData;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WorkspaceElements;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WorkspaceSwingFrame;

class InstrumentMultiInstrumentData
extends MultiInstrumentData {
    private WorkspaceElements[] theElements;
    private WorkspaceSwingFrame theWorkspace;
    private ApplicationObject theApplicationObject;
    private ApplicationObject theInstrumentApplicationObject = null;
    private MaskedIntegerValue previousValue = null;

    public InstrumentMultiInstrumentData(WorkspaceElements[] workspaceElementsArray, WorkspaceSwingFrame workspaceSwingFrame) {
        this.theElements = workspaceElementsArray;
        this.theWorkspace = workspaceSwingFrame;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
        } else {
            this.theInstrumentApplicationObject = applicationObject;
        }
    }

    public boolean change(ApplicationData applicationData) {
        boolean bl = false;
        if (this.previousValue != null && applicationData instanceof MaskedIntegerValue) {
            MaskedIntegerValue maskedIntegerValue = (MaskedIntegerValue)applicationData;
            if (this.previousValue.getValue() != maskedIntegerValue.getValue()) {
                bl = this.theInstrumentApplicationObject.change(maskedIntegerValue);
                if (bl) {
                    this.theWorkspace.setElements(this.theElements[maskedIntegerValue.getValue()]);
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void doInitialisation() {
        this.theWorkspace.initialise(this, this.theElements, this.previousValue.getValue(), this.theInstrumentApplicationObject.getName());
    }

    public int getInitialisationState() {
        int n;
        int n2 = n = this.theInstrumentApplicationObject == null ? 1 : this.theInstrumentApplicationObject.getInitialisationState();
        if (n == 2) {
            n = this.previousValue == null ? 0 : 2;
        }
        return n;
    }

    public void initialiseProxy(ApplicationObject applicationObject) {
        this.theApplicationObject = applicationObject;
    }

    private void permanentError() {
        if (this.theInstrumentApplicationObject != null) {
            this.theInstrumentApplicationObject.unregister(this);
            this.theInstrumentApplicationObject = null;
        }
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        this.previousValue.receivedBy(applicationDataReceiver, applicationDataSender);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theInstrumentApplicationObject) {
            if (!maskedIntegerValue.equals(this.previousValue)) {
                if (this.previousValue == null) {
                    this.previousValue = maskedIntegerValue;
                    InstrumentMultiInstrumentData instrumentMultiInstrumentData = this;
                    synchronized (instrumentMultiInstrumentData) {
                        this.notify();
                    }
                } else {
                    this.previousValue = maskedIntegerValue;
                    try {
                        this.theApplicationObject.asyncUpdate();
                    }
                    catch (OperationFailedException operationFailedException) {}
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public String toString() {
        return "Data for " + this.theApplicationObject;
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

