/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.MenuPathSelector;
import java.awt.Component;

class KeyHandlerWindowInfo {
    private InternalWindow theWindow = null;
    private Component focusedComponent = null;
    private UnconsumedKeyHandler theKeyHandler = null;
    private KeyHandlerWindowInfo previousWindowInfo;

    public KeyHandlerWindowInfo() {
    }

    public KeyHandlerWindowInfo(InternalWindow internalWindow, UnconsumedKeyHandler unconsumedKeyHandler, KeyHandlerWindowInfo keyHandlerWindowInfo) {
        this.setWindow(internalWindow);
        this.theKeyHandler = unconsumedKeyHandler;
        this.previousWindowInfo = keyHandlerWindowInfo;
    }

    public void clearInfo() {
        if (this.theWindow != null) {
            MenuPathSelector menuPathSelector = WindowManager.instance().getMenuElement(this.theWindow.getClass().getName());
            if (menuPathSelector != null) {
                menuPathSelector.unregisterObserver(this.theWindow);
            }
            this.theWindow = null;
        }
        this.theKeyHandler = null;
        this.previousWindowInfo = null;
        this.focusedComponent = null;
    }

    public boolean equals(InternalWindow internalWindow) {
        return internalWindow == this.theWindow && internalWindow != null;
    }

    public Component getFocusedComponent() {
        return this.focusedComponent;
    }

    public UnconsumedKeyHandler getKeyHandler() {
        return this.theKeyHandler;
    }

    public KeyHandlerWindowInfo getPreviousWindowInfo() {
        return this.previousWindowInfo;
    }

    public InternalWindow getWindow() {
        return this.theWindow;
    }

    public boolean hasWindow() {
        return this.theWindow != null;
    }

    public void setFocusedComponent(Component component) {
        this.focusedComponent = component;
    }

    public void setPreviousWindowInfo(KeyHandlerWindowInfo keyHandlerWindowInfo) {
        this.previousWindowInfo = keyHandlerWindowInfo;
    }

    public void setVisible(boolean bl) {
        if (this.theWindow != null && this.theWindow.getContainer().isVisible() != bl) {
            this.theWindow.getContainer().setVisible(bl);
        }
    }

    private void setWindow(InternalWindow internalWindow) {
        this.theWindow = internalWindow;
        MenuPathSelector menuPathSelector = WindowManager.instance().getMenuElement(internalWindow.getClass().getName());
        if (menuPathSelector != null) {
            menuPathSelector.registerObserver(internalWindow);
        }
    }

    public String toString() {
        String string = this.getWindow() == null ? "Null" : this.getWindow().toString();
        return "KeyHandler for " + string;
    }
}

