/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.SelectedWindowHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.KeyHandlerWindowInfo;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WorkspaceSwingFrame;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.StringReader;

public class WindowSelector
implements SelectedWindowHandler {
    private KeyHandlerWindowInfo windowLEFT = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo windowRIGHT = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo windowDOUBLE = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo windowFULL = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo windowHELP = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo windowSUMMARY = new KeyHandlerWindowInfo();
    private KeyHandlerWindowInfo selectedWindow = new KeyHandlerWindowInfo();
    private final boolean forcesPreferredLocation = true;
    private final int LAYER_WINDOW = 2;
    private final int LAYER_MODAL = 0;
    private final int LAYER_BACK = -1;
    private List modalWindowList = new ArrayList(6);
    private final Container theWindowContainer;

    public WindowSelector(Container container) {
        this.theWindowContainer = container;
    }

    public void addInternalWindow(InternalWindow internalWindow, int n, UnconsumedKeyHandler unconsumedKeyHandler) {
        KeyHandlerWindowInfo keyHandlerWindowInfo = null;
        switch (n) {
            case 1: {
                if (!this.shouldUsePreferredLocation() && this.selectedWindow != null && this.selectedWindow == this.windowRIGHT) {
                    internalWindow.getContainer().setBounds(InternalWindow.BOUNDS_RIGHT);
                    keyHandlerWindowInfo = this.windowRIGHT;
                    this.windowRIGHT = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                    break;
                }
                internalWindow.getContainer().setBounds(InternalWindow.BOUNDS_LEFT);
                keyHandlerWindowInfo = this.windowLEFT;
                this.windowLEFT = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                break;
            }
            case 2: {
                if (!this.shouldUsePreferredLocation() && this.selectedWindow != null && this.selectedWindow == this.windowLEFT) {
                    internalWindow.getContainer().setBounds(InternalWindow.BOUNDS_LEFT);
                    keyHandlerWindowInfo = this.windowLEFT;
                    this.windowLEFT = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                    break;
                }
                internalWindow.getContainer().setBounds(InternalWindow.BOUNDS_RIGHT);
                keyHandlerWindowInfo = this.windowRIGHT;
                this.windowRIGHT = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                break;
            }
            case 4: {
                internalWindow.getContainer().setBounds(InternalWindow.BOUNDS_FULL);
                keyHandlerWindowInfo = this.windowFULL;
                this.windowFULL = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                break;
            }
            case 3: {
                keyHandlerWindowInfo = this.windowDOUBLE;
                this.windowDOUBLE = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, null);
                break;
            }
            case 0: {
                Dimension dimension = this.theWindowContainer.getSize();
                int n2 = dimension.width / 2 - internalWindow.getContainer().getSize().width / 2;
                int n3 = WorkspaceSwingFrame.CONTEXT_HELP_BOUNDS.y / 2 - internalWindow.getContainer().getSize().height / 2;
                internalWindow.getContainer().setLocation(n2, n3);
                this.modalWindowList.add(0, (Object)new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, this.selectedWindow));
                break;
            }
            case 6: {
                this.windowHELP = new KeyHandlerWindowInfo(internalWindow, unconsumedKeyHandler, this.selectedWindow);
                break;
            }
            case 5: {
                keyHandlerWindowInfo = this.windowSUMMARY;
                this.windowSUMMARY = new KeyHandlerWindowInfo(internalWindow, null, null);
            }
        }
        int n4 = this.defineWindowLayer(n);
        this.theWindowContainer.add((Component)internalWindow.getContainer(), n4);
        if (keyHandlerWindowInfo != null && keyHandlerWindowInfo.hasWindow()) {
            this.hideRemoveUnregisterWindow(keyHandlerWindowInfo.getWindow());
            keyHandlerWindowInfo.clearInfo();
        }
        if (n == 0) {
            this.checkModalWindowQuantity();
        }
    }

    public boolean attemptSelectWindow(InternalWindow internalWindow) {
        boolean bl = false;
        if (internalWindow == null) {
            throw new NullPointerException("Workspace cannot select Null window");
        }
        if (internalWindow == this.getSelectedWindow()) {
            bl = true;
        } else if (internalWindow.isSelectable() && internalWindow.getContainer().isVisible() && this.isTopMostWindow(internalWindow)) {
            this.selectWindow(internalWindow);
            bl = true;
        }
        return bl;
    }

    private void changeWindowSelectionState(KeyHandlerWindowInfo keyHandlerWindowInfo, boolean bl) {
        if (bl) {
            if (this.selectedWindow.hasWindow()) {
                this.selectedWindow.getWindow().setSelected(false, null);
                this.selectedWindow.setFocusedComponent(EclipseFocusManager.getInstance().getWindowFocusedComponent());
                this.selectedWindow.getWindow().getContainer().repaint();
            }
            this.selectedWindow = keyHandlerWindowInfo;
        }
        keyHandlerWindowInfo.getWindow().setSelected(bl, keyHandlerWindowInfo.getFocusedComponent());
        keyHandlerWindowInfo.getWindow().getContainer().repaint();
    }

    private void checkModalWindowQuantity() {
        if (this.modalWindowList.size() == 20) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("Too many windows on screen. Limit is ");
            stringBuffer.append(20);
            stringBuffer.append('\n');
            stringBuffer.append("Method: checkModalWindowQuantity()");
            stringBuffer.append('\n');
            stringBuffer.append("Class: ");
            stringBuffer.append(this.getClass().toString());
            stringBuffer.append('\n');
            stringBuffer.append(this.modalWindowList.toString());
            StringReader stringReader = new StringReader(stringBuffer.toString());
            WindowManager.instance().createModalErrorWindow(stringReader);
        }
    }

    private void completeWindowSelection(KeyHandlerWindowInfo keyHandlerWindowInfo) {
        this.changeWindowSelectionState(keyHandlerWindowInfo, keyHandlerWindowInfo.getWindow().isSelectable());
        if (!keyHandlerWindowInfo.getWindow().isSelectable() && this.selectedWindow != null) {
            this.changeWindowSelectionState(this.selectedWindow, true);
        }
    }

    private int defineWindowLayer(int n) {
        int n2 = -1;
        if (n == 0 || n == 6 || n == 4) {
            n2 = 0;
        } else if (this.theWindowContainer.getComponentCount() >= 2) {
            n2 = 2;
        }
        return n2;
    }

    KeyHandlerWindowInfo getSelectedKeyHandlerWindowInfo() {
        return this.selectedWindow;
    }

    public InternalWindow getSelectedWindow() {
        return this.selectedWindow == null ? null : this.selectedWindow.getWindow();
    }

    private void hideRemoveUnregisterWindow(InternalWindow internalWindow) {
        internalWindow.getContainer().setVisible(false);
        this.theWindowContainer.remove(internalWindow.getContainer());
        internalWindow.unregister();
    }

    private boolean isTopMostWindow(InternalWindow internalWindow) {
        boolean bl = false;
        if (this.theWindowContainer.getComponent(0) == internalWindow) {
            bl = true;
        } else if (this.modalWindowList.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    public void nextWindowAction() {
        if (this.selectedWindow == this.windowLEFT) {
            if (this.windowRIGHT.getWindow().isSelectable()) {
                this.selectWindow(this.windowRIGHT.getWindow());
            }
        } else if (this.selectedWindow == this.windowRIGHT && this.windowLEFT.getWindow().isSelectable()) {
            this.selectWindow(this.windowLEFT.getWindow());
        }
    }

    private boolean removeFromMainWindows(InternalWindow internalWindow, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.windowFULL != null && internalWindow == this.windowFULL.getWindow() && this.windowFULL.getPreviousWindowInfo() != null) {
                this.hideRemoveUnregisterWindow(internalWindow);
                this.selectWindow(this.windowFULL.getPreviousWindowInfo().getWindow());
                this.windowFULL.clearInfo();
                bl2 = true;
            }
        } else if (internalWindow == this.windowLEFT.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowLEFT.clearInfo();
            bl2 = true;
        } else if (internalWindow == this.windowRIGHT.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowRIGHT.clearInfo();
            bl2 = true;
        } else if (internalWindow == this.windowFULL.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowFULL.clearInfo();
            bl2 = true;
        } else if (internalWindow == this.windowDOUBLE.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowDOUBLE.clearInfo();
            bl2 = true;
        } else if (internalWindow == this.windowSUMMARY.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowSUMMARY.clearInfo();
            bl2 = true;
        } else if (internalWindow == this.windowHELP.getWindow()) {
            this.hideRemoveUnregisterWindow(internalWindow);
            this.windowHELP.clearInfo();
            bl2 = true;
        }
        return bl2;
    }

    private boolean removeFromModals(InternalWindow internalWindow) {
        boolean bl = false;
        int n = 1;
        while (n < this.modalWindowList.size()) {
            if (((KeyHandlerWindowInfo)this.modalWindowList.get(n)).equals(internalWindow)) {
                if (n != 0) {
                    KeyHandlerWindowInfo keyHandlerWindowInfo = (KeyHandlerWindowInfo)this.modalWindowList.get(n);
                    KeyHandlerWindowInfo keyHandlerWindowInfo2 = (KeyHandlerWindowInfo)this.modalWindowList.get(n - 1);
                    keyHandlerWindowInfo2.setPreviousWindowInfo(keyHandlerWindowInfo.getPreviousWindowInfo());
                }
                this.modalWindowList.remove(n);
                this.hideRemoveUnregisterWindow(internalWindow);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean removeWindow(InternalWindow internalWindow, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.modalWindowList.isEmpty()) {
                bl2 = this.removeFromMainWindows(internalWindow, true);
            } else if (((KeyHandlerWindowInfo)this.modalWindowList.get(0)).getWindow().equals(internalWindow)) {
                KeyHandlerWindowInfo keyHandlerWindowInfo = ((KeyHandlerWindowInfo)this.modalWindowList.remove(0)).getPreviousWindowInfo();
                internalWindow.getContainer().setVisible(false);
                this.theWindowContainer.remove(internalWindow.getContainer());
                this.selectWindow(keyHandlerWindowInfo.getWindow());
                internalWindow.unregister();
                bl2 = true;
            }
        } else if (!this.removeFromMainWindows(internalWindow, false)) {
            bl2 = this.removeFromModals(internalWindow);
        }
        return bl2;
    }

    private void selectDoubleWindow() {
        this.windowHELP.setVisible(false);
        this.windowFULL.setVisible(false);
        this.windowLEFT.setVisible(false);
        this.windowRIGHT.setVisible(false);
        this.windowDOUBLE.setVisible(true);
        this.completeWindowSelection(this.windowDOUBLE);
    }

    private void selectFullWindow() {
        this.windowHELP.setVisible(false);
        this.windowDOUBLE.setVisible(false);
        this.windowLEFT.setVisible(false);
        this.windowRIGHT.setVisible(false);
        this.windowFULL.setVisible(true);
        this.completeWindowSelection(this.windowFULL);
    }

    private void selectLeftWindow() {
        this.windowHELP.setVisible(false);
        this.windowDOUBLE.setVisible(false);
        this.windowFULL.setVisible(false);
        this.windowRIGHT.setVisible(true);
        this.windowLEFT.setVisible(true);
        this.completeWindowSelection(this.windowLEFT);
    }

    private void selectModalWindow(InternalWindow internalWindow) {
        if (!this.modalWindowList.isEmpty() && ((KeyHandlerWindowInfo)this.modalWindowList.get(0)).getWindow() == internalWindow) {
            this.windowHELP.setVisible(false);
            KeyHandlerWindowInfo keyHandlerWindowInfo = (KeyHandlerWindowInfo)this.modalWindowList.get(0);
            if (this.selectedWindow != keyHandlerWindowInfo) {
                EclipseFocusManager.getInstance().changeLockState(false, null);
            }
            keyHandlerWindowInfo.setVisible(true);
            this.completeWindowSelection(keyHandlerWindowInfo);
        }
    }

    private void selectRightWindow() {
        this.windowHELP.setVisible(false);
        this.windowDOUBLE.setVisible(false);
        this.windowFULL.setVisible(false);
        this.windowLEFT.setVisible(true);
        this.windowRIGHT.setVisible(true);
        this.completeWindowSelection(this.windowRIGHT);
    }

    void selectTopWindow() {
        if (this.selectedWindow == null || this.selectedWindow.getWindow() == null) {
            if (this.windowFULL.getWindow() != null && this.windowFULL.getWindow().isSelectable()) {
                this.changeWindowSelectionState(this.windowLEFT, false);
                this.changeWindowSelectionState(this.windowRIGHT, false);
                this.selectWindow(this.windowFULL.getWindow());
            } else if (this.windowLEFT.getWindow().isSelectable()) {
                this.changeWindowSelectionState(this.windowRIGHT, false);
                this.selectWindow(this.windowLEFT.getWindow());
            } else if (this.windowRIGHT.getWindow().isSelectable()) {
                this.changeWindowSelectionState(this.windowLEFT, false);
                this.selectWindow(this.windowRIGHT.getWindow());
            } else {
                this.changeWindowSelectionState(this.windowRIGHT, false);
                this.changeWindowSelectionState(this.windowLEFT, false);
            }
        } else {
            if (this.windowLEFT.getWindow().isSelectable()) {
                this.selectedWindow.setPreviousWindowInfo(this.windowLEFT);
            } else {
                this.selectedWindow.setPreviousWindowInfo(this.windowRIGHT);
            }
            this.selectedWindow.getWindow().setSelected(true, this.selectedWindow.getFocusedComponent());
        }
    }

    public void selectWindow(InternalWindow internalWindow) {
        if (internalWindow == null) {
            throw new NullPointerException("Workspace cannot select Null window");
        }
        if (this.windowLEFT.equals(internalWindow)) {
            this.selectLeftWindow();
        } else if (this.windowRIGHT.equals(internalWindow)) {
            this.selectRightWindow();
        } else if (this.windowDOUBLE.equals(internalWindow)) {
            this.selectDoubleWindow();
        } else if (this.windowFULL.equals(internalWindow)) {
            this.selectFullWindow();
        } else if (this.windowHELP.equals(internalWindow)) {
            this.windowHELP.setVisible(true);
            this.completeWindowSelection(this.windowHELP);
        } else if (this.windowSUMMARY.equals(internalWindow)) {
            this.completeWindowSelection(this.windowSUMMARY);
        } else {
            this.selectModalWindow(internalWindow);
        }
    }

    private boolean shouldUsePreferredLocation() {
        return true;
    }

    public void toggleOnLineHelp() {
        if (this.windowHELP.getWindow() == null) {
            WindowManager.instance().createWindow("com.agilent.tntd.eclipse.viewlayer.components.help.EclHelpHtmlWindow");
        } else if (this.selectedWindow != this.windowHELP) {
            this.windowHELP.setPreviousWindowInfo(this.selectedWindow);
            this.theWindowContainer.remove(this.windowHELP.getWindow().getContainer());
            this.theWindowContainer.add((Component)this.windowHELP.getWindow().getContainer(), 0);
            this.selectWindow(this.windowHELP.getWindow());
        } else {
            this.selectWindow(this.windowHELP.getPreviousWindowInfo().getWindow());
        }
    }

    public void unregisterWindows(boolean bl) {
        if (this.windowLEFT.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowLEFT.getWindow());
            this.windowLEFT.clearInfo();
        }
        if (this.windowRIGHT.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowRIGHT.getWindow());
            this.windowRIGHT.clearInfo();
        }
        if (this.windowDOUBLE.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowDOUBLE.getWindow());
            this.windowDOUBLE.clearInfo();
        }
        if (this.windowFULL.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowFULL.getWindow());
            this.windowFULL.clearInfo();
        }
        if (bl && this.windowHELP.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowHELP.getWindow());
            this.windowHELP.clearInfo();
        }
        if (this.windowSUMMARY.getWindow() != null) {
            this.hideRemoveUnregisterWindow(this.windowSUMMARY.getWindow());
            this.windowSUMMARY.clearInfo();
        }
        while (!this.modalWindowList.isEmpty()) {
            KeyHandlerWindowInfo keyHandlerWindowInfo = (KeyHandlerWindowInfo)this.modalWindowList.get(0);
            this.hideRemoveUnregisterWindow(keyHandlerWindowInfo.getWindow());
            this.modalWindowList.remove((Object)keyHandlerWindowInfo);
        }
        if (this.selectedWindow.getWindow() != null) {
            this.selectedWindow.clearInfo();
        }
    }
}

